/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.db.pipe.task.PipeTask;

public class PipeTaskManager {
    private final Map<PipeStaticMeta, Map<TConsensusGroupId, PipeTask>> pipeMap = new HashMap<PipeStaticMeta, Map<TConsensusGroupId, PipeTask>>();
    private volatile int leaderDataRegionCount = 0;

    public synchronized void addPipeTask(PipeStaticMeta pipeStaticMeta, TConsensusGroupId consensusGroupId, PipeTask pipeTask) {
        Map dataRegionId2PipeTask = this.pipeMap.computeIfAbsent(pipeStaticMeta, k -> new HashMap());
        dataRegionId2PipeTask.put(consensusGroupId, pipeTask);
        this.leaderDataRegionCount = Math.max(this.leaderDataRegionCount, dataRegionId2PipeTask.size());
    }

    public synchronized void addPipeTasks(PipeStaticMeta pipeStaticMeta, Map<TConsensusGroupId, PipeTask> pipeTasks) {
        Map dataRegionId2PipeTask = this.pipeMap.computeIfAbsent(pipeStaticMeta, k -> new HashMap());
        dataRegionId2PipeTask.putAll(pipeTasks);
        this.leaderDataRegionCount = Math.max(this.leaderDataRegionCount, dataRegionId2PipeTask.size());
    }

    public synchronized PipeTask removePipeTask(PipeStaticMeta pipeStaticMeta, TConsensusGroupId consensusGroupId) {
        Map<TConsensusGroupId, PipeTask> consensusGroupIdPipeTaskMap = this.pipeMap.get(pipeStaticMeta);
        if (consensusGroupIdPipeTaskMap != null) {
            return consensusGroupIdPipeTaskMap.remove(consensusGroupId);
        }
        return null;
    }

    public synchronized Map<TConsensusGroupId, PipeTask> removePipeTasks(PipeStaticMeta pipeStaticMeta) {
        return this.pipeMap.remove(pipeStaticMeta);
    }

    public synchronized PipeTask getPipeTask(PipeStaticMeta pipeStaticMeta, TConsensusGroupId consensusGroupId) {
        Map<TConsensusGroupId, PipeTask> consensusGroupIdPipeTaskMap = this.pipeMap.get(pipeStaticMeta);
        if (consensusGroupIdPipeTaskMap != null) {
            return consensusGroupIdPipeTaskMap.get(consensusGroupId);
        }
        return null;
    }

    public synchronized Map<TConsensusGroupId, PipeTask> getPipeTasks(PipeStaticMeta pipeStaticMeta) {
        return this.pipeMap.get(pipeStaticMeta);
    }

    public int getLeaderDataRegionCount() {
        return this.leaderDataRegionCount;
    }
}

