/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task;

import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.task.PipeTask;
import org.apache.iotdb.db.pipe.task.stage.PipeTaskConnectorStage;
import org.apache.iotdb.db.pipe.task.stage.PipeTaskExtractorStage;
import org.apache.iotdb.db.pipe.task.stage.PipeTaskProcessorStage;

public class PipeTaskBuilder {
    private final PipeStaticMeta pipeStaticMeta;
    private final TConsensusGroupId dataRegionId;
    private final PipeTaskMeta pipeTaskMeta;

    public PipeTaskBuilder(PipeStaticMeta pipeStaticMeta, TConsensusGroupId dataRegionId, PipeTaskMeta pipeTaskMeta) {
        this.pipeStaticMeta = pipeStaticMeta;
        this.dataRegionId = dataRegionId;
        this.pipeTaskMeta = pipeTaskMeta;
    }

    public PipeTask build() {
        PipeTaskExtractorStage extractorStage = new PipeTaskExtractorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), this.pipeStaticMeta.getExtractorParameters(), this.dataRegionId, this.pipeTaskMeta);
        PipeTaskConnectorStage connectorStage = new PipeTaskConnectorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), this.pipeStaticMeta.getConnectorParameters());
        PipeTaskProcessorStage processorStage = new PipeTaskProcessorStage(this.pipeStaticMeta.getPipeName(), this.pipeStaticMeta.getCreationTime(), this.pipeStaticMeta.getProcessorParameters(), this.dataRegionId, extractorStage.getEventSupplier(), connectorStage.getPipeConnectorPendingQueue());
        return new PipeTask(this.pipeStaticMeta.getPipeName(), this.dataRegionId, extractorStage, processorStage, connectorStage);
    }
}

