/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task;

import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.db.pipe.task.stage.PipeTaskStage;

public class PipeTask {
    private final String pipeName;
    private final TConsensusGroupId dataRegionId;
    private final PipeTaskStage extractorStage;
    private final PipeTaskStage processorStage;
    private final PipeTaskStage connectorStage;

    PipeTask(String pipeName, TConsensusGroupId dataRegionId, PipeTaskStage extractorStage, PipeTaskStage processorStage, PipeTaskStage connectorStage) {
        this.pipeName = pipeName;
        this.dataRegionId = dataRegionId;
        this.extractorStage = extractorStage;
        this.processorStage = processorStage;
        this.connectorStage = connectorStage;
    }

    public void create() {
        this.extractorStage.create();
        this.processorStage.create();
        this.connectorStage.create();
    }

    public void drop() {
        this.extractorStage.drop();
        this.processorStage.drop();
        this.connectorStage.drop();
    }

    public void start() {
        this.extractorStage.start();
        this.processorStage.start();
        this.connectorStage.start();
    }

    public void stop() {
        this.extractorStage.stop();
        this.processorStage.stop();
        this.connectorStage.stop();
    }

    public TConsensusGroupId getDataRegionId() {
        return this.dataRegionId;
    }

    public String getPipeName() {
        return this.pipeName;
    }
}

