/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.historical;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.extractor.historical.PipeHistoricalDataRegionExtractor;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHistoricalDataRegionTsFileExtractor
implements PipeHistoricalDataRegionExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHistoricalDataRegionTsFileExtractor.class);
    private static final Map<Integer, Long> DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP = new HashMap<Integer, Long>();
    private static final long PIPE_MIN_FLUSH_INTERVAL_IN_MS = 2000L;
    private PipeTaskMeta pipeTaskMeta;
    private ProgressIndex startIndex;
    private int dataRegionId;
    private String pattern;
    private boolean isDbNameCoveredByPattern = false;
    private long historicalDataExtractionStartTime;
    private long historicalDataExtractionEndTime;
    private long historicalDataExtractionTimeLowerBound;
    private boolean sloppyTimeRange;
    private Queue<TsFileResource> pendingQueue;

    public void validate(PipeParameterValidator validator) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) {
        boolean isHistoricalExtractorEnabledByUser;
        String databaseName;
        PipeTaskExtractorRuntimeEnvironment environment = (PipeTaskExtractorRuntimeEnvironment)configuration.getRuntimeEnvironment();
        this.pipeTaskMeta = environment.getPipeTaskMeta();
        this.startIndex = environment.getPipeTaskMeta().getProgressIndex();
        this.dataRegionId = environment.getRegionId();
        Map<Integer, Long> map = DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP;
        synchronized (map) {
            DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP.putIfAbsent(this.dataRegionId, 0L);
        }
        this.pattern = parameters.getStringOrDefault(Arrays.asList("extractor.pattern", "source.pattern"), "root");
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(environment.getRegionId()));
        if (dataRegion != null && (databaseName = dataRegion.getDatabaseName()) != null && this.pattern.length() <= databaseName.length() && databaseName.startsWith(this.pattern)) {
            this.isDbNameCoveredByPattern = true;
        }
        this.historicalDataExtractionStartTime = (isHistoricalExtractorEnabledByUser = parameters.getBooleanOrDefault(Arrays.asList("extractor.history.enable", "source.history.enable"), true)) && parameters.hasAnyAttributes(new String[]{"extractor.history.start-time", "source.history.start-time"}) ? DateTimeUtils.convertDatetimeStrToLong(parameters.getStringByKeys(new String[]{"extractor.history.start-time", "source.history.start-time"}), ZoneId.systemDefault()) : Long.MIN_VALUE;
        this.historicalDataExtractionEndTime = isHistoricalExtractorEnabledByUser && parameters.hasAnyAttributes(new String[]{"extractor.history.end-time", "source.history.end-time"}) ? DateTimeUtils.convertDatetimeStrToLong(parameters.getStringByKeys(new String[]{"extractor.history.end-time", "source.history.end-time"}), ZoneId.systemDefault()) : Long.MAX_VALUE;
        long l = this.historicalDataExtractionTimeLowerBound = parameters.getBooleanOrDefault(Arrays.asList("extractor.history.enable", "source.history.enable"), true) ? Long.MIN_VALUE : environment.getCreationTime();
        if (this.historicalDataExtractionTimeLowerBound != Long.MIN_VALUE) {
            Map<Integer, Long> map2 = DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP;
            synchronized (map2) {
                long lastFlushedByPipeTime = DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP.get(this.dataRegionId);
                if (System.currentTimeMillis() - lastFlushedByPipeTime >= 2000L) {
                    this.flushDataRegionAllTsFiles();
                    DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP.replace(this.dataRegionId, System.currentTimeMillis());
                }
            }
        }
        this.sloppyTimeRange = Arrays.stream(parameters.getStringOrDefault(Arrays.asList("extractor.history.loose-range", "source.history.loose-range"), "").split(",")).map(String::trim).map(String::toLowerCase).collect(Collectors.toSet()).contains("time");
        LOGGER.info("historical data extraction time range, start time {}({}), end time {}({}), sloppy time range {}", new Object[]{DateTimeUtils.convertLongToDate(this.historicalDataExtractionStartTime), this.historicalDataExtractionStartTime, DateTimeUtils.convertLongToDate(this.historicalDataExtractionEndTime), this.historicalDataExtractionEndTime, this.sloppyTimeRange});
    }

    private void flushDataRegionAllTsFiles() {
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(this.dataRegionId));
        if (dataRegion == null) {
            return;
        }
        dataRegion.writeLock("Pipe: create historical TsFile extractor");
        try {
            dataRegion.syncCloseAllWorkingTsFileProcessors();
        }
        finally {
            dataRegion.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(this.dataRegionId));
        if (dataRegion == null) {
            this.pendingQueue = new ArrayDeque<TsFileResource>();
            return;
        }
        dataRegion.writeLock("Pipe: start to extract historical TsFile");
        long startHistoricalExtractionTime = System.currentTimeMillis();
        try {
            Map<Integer, Long> map = DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP;
            synchronized (map) {
                long lastFlushedByPipeTime = DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP.get(this.dataRegionId);
                if (System.currentTimeMillis() - lastFlushedByPipeTime >= 2000L) {
                    dataRegion.syncCloseAllWorkingTsFileProcessors();
                    DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP.replace(this.dataRegionId, System.currentTimeMillis());
                }
            }
            TsFileManager tsFileManager = dataRegion.getTsFileManager();
            tsFileManager.readLock();
            try {
                ArrayList resourceList = new ArrayList(tsFileManager.size(true) + tsFileManager.size(false));
                Collection sequenceTsFileResources = tsFileManager.getTsFileList(true).stream().filter(resource -> resource.isClosed() && !this.startIndex.isAfter(resource.getMaxProgressIndexAfterClose()) && this.isTsFileResourceOverlappedWithTimeRange((TsFileResource)resource) && this.isTsFileGeneratedAfterExtractionTimeLowerBound((TsFileResource)resource)).collect(Collectors.toList());
                resourceList.addAll(sequenceTsFileResources);
                Collection unsequenceTsFileResources = tsFileManager.getTsFileList(false).stream().filter(resource -> resource.isClosed() && !this.startIndex.isAfter(resource.getMaxProgressIndexAfterClose()) && this.isTsFileResourceOverlappedWithTimeRange((TsFileResource)resource) && this.isTsFileGeneratedAfterExtractionTimeLowerBound((TsFileResource)resource)).collect(Collectors.toList());
                resourceList.addAll(unsequenceTsFileResources);
                resourceList.forEach(resource -> {
                    try {
                        PipeResourceManager.tsfile().pinTsFileResource((TsFileResource)resource);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Pipe: failed to pin TsFileResource {}", (Object)resource.getTsFilePath());
                    }
                });
                resourceList.sort((o1, o2) -> o1.getMaxProgressIndex().topologicalCompareTo(o2.getMaxProgressIndex()));
                this.pendingQueue = new ArrayDeque<TsFileResource>(resourceList);
                LOGGER.info("Pipe: start to extract historical TsFile, data region {}, sequence file count {}, unsequence file count {}, historical extraction time {} ms", new Object[]{this.dataRegionId, sequenceTsFileResources.size(), unsequenceTsFileResources.size(), System.currentTimeMillis() - startHistoricalExtractionTime});
            }
            finally {
                tsFileManager.readUnlock();
            }
        }
        finally {
            dataRegion.writeUnlock();
        }
    }

    private boolean isTsFileResourceOverlappedWithTimeRange(TsFileResource resource) {
        return resource.getFileEndTime() >= this.historicalDataExtractionStartTime && this.historicalDataExtractionEndTime >= resource.getFileStartTime();
    }

    private boolean isTsFileResourceCoveredByTimeRange(TsFileResource resource) {
        return this.historicalDataExtractionStartTime <= resource.getFileStartTime() && this.historicalDataExtractionEndTime >= resource.getFileEndTime();
    }

    private boolean isTsFileGeneratedAfterExtractionTimeLowerBound(TsFileResource resource) {
        try {
            return this.historicalDataExtractionTimeLowerBound <= TsFileNameGenerator.getTsFileName(resource.getTsFile().getName()).getTime();
        }
        catch (IOException e) {
            LOGGER.warn(String.format("failed to get the generation time of TsFile %s, extract it anyway", resource.getTsFilePath()), (Throwable)e);
            return true;
        }
    }

    public synchronized Event supply() {
        if (this.pendingQueue == null) {
            return null;
        }
        TsFileResource resource = this.pendingQueue.poll();
        if (resource == null) {
            return null;
        }
        PipeTsFileInsertionEvent event = new PipeTsFileInsertionEvent(resource, false, false, this.pipeTaskMeta, this.pattern, this.historicalDataExtractionStartTime, this.historicalDataExtractionEndTime, !this.sloppyTimeRange && !this.isTsFileResourceCoveredByTimeRange(resource));
        if (this.isDbNameCoveredByPattern) {
            event.skipParsingPattern();
        }
        event.increaseReferenceCount(PipeHistoricalDataRegionTsFileExtractor.class.getName());
        try {
            PipeResourceManager.tsfile().unpinTsFileResource(resource);
        }
        catch (IOException e) {
            LOGGER.warn("Pipe: failed to unpin TsFileResource after creating event, original path: {}", (Object)resource.getTsFilePath());
        }
        return event;
    }

    @Override
    public synchronized boolean hasConsumedAll() {
        return this.pendingQueue != null && this.pendingQueue.isEmpty();
    }

    @Override
    public int getPendingQueueSize() {
        return this.pendingQueue != null ? this.pendingQueue.size() : 0;
    }

    public synchronized void close() {
        if (this.pendingQueue != null) {
            this.pendingQueue.forEach(resource -> {
                try {
                    PipeResourceManager.tsfile().unpinTsFileResource((TsFileResource)resource);
                }
                catch (IOException e) {
                    LOGGER.warn("Pipe: failed to unpin TsFileResource after dropping pipe, original path: {}", (Object)resource.getTsFilePath());
                }
            });
            this.pendingQueue.clear();
            this.pendingQueue = null;
        }
    }
}

