/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.websocket;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.iotdb.db.pipe.connector.protocol.websocket.WebSocketConnectorServer;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnector
implements PipeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketConnector.class);
    private static final Map<Integer, Pair<AtomicInteger, WebSocketConnectorServer>> PORT_TO_REFERENCE_COUNT_AND_SERVER_MAP = new ConcurrentHashMap<Integer, Pair<AtomicInteger, WebSocketConnectorServer>>();
    private Integer port;
    private WebSocketConnectorServer server;
    public final AtomicLong commitIdGenerator = new AtomicLong(0L);
    private final AtomicLong lastCommitId = new AtomicLong(0L);
    private final PriorityQueue<Pair<Long, Runnable>> commitQueue = new PriorityQueue<Pair>(Comparator.comparing(o -> (Long)o.left));

    public void validate(PipeParameterValidator validator) throws Exception {
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        this.port = parameters.getIntOrDefault(Arrays.asList("connector.websocket.port", "sink.websocket.port"), 8080);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshake() throws Exception {
        Map<Integer, Pair<AtomicInteger, WebSocketConnectorServer>> map = PORT_TO_REFERENCE_COUNT_AND_SERVER_MAP;
        synchronized (map) {
            this.server = (WebSocketConnectorServer)((Object)PORT_TO_REFERENCE_COUNT_AND_SERVER_MAP.computeIfAbsent(this.port, key -> {
                WebSocketConnectorServer newServer = new WebSocketConnectorServer(new InetSocketAddress(this.port), this);
                newServer.start();
                return new Pair((Object)new AtomicInteger(0), (Object)newServer);
            }).getRight());
            ((AtomicInteger)PORT_TO_REFERENCE_COUNT_AND_SERVER_MAP.get(this.port).getLeft()).incrementAndGet();
        }
    }

    public void heartbeat() throws Exception {
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) {
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("WebsocketConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Current event: {}.", (Object)tabletInsertionEvent);
            return;
        }
        long commitId = this.commitIdGenerator.incrementAndGet();
        ((EnrichedEvent)tabletInsertionEvent).increaseReferenceCount(WebSocketConnector.class.getName());
        this.server.addEvent((Pair<Long, Event>)new Pair((Object)commitId, (Object)tabletInsertionEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("WebsocketConnector only support PipeTsFileInsertionEvent. Current event: {}.", (Object)tsFileInsertionEvent);
            return;
        }
        try {
            for (TabletInsertionEvent event : tsFileInsertionEvent.toTabletInsertionEvents()) {
                long commitId = this.commitIdGenerator.incrementAndGet();
                ((EnrichedEvent)event).increaseReferenceCount(WebSocketConnector.class.getName());
                this.server.addEvent((Pair<Long, Event>)new Pair((Object)commitId, (Object)event));
            }
        }
        finally {
            tsFileInsertionEvent.close();
        }
    }

    public void transfer(Event event) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        if (this.port == null) {
            return;
        }
        Map<Integer, Pair<AtomicInteger, WebSocketConnectorServer>> map = PORT_TO_REFERENCE_COUNT_AND_SERVER_MAP;
        synchronized (map) {
            Pair<AtomicInteger, WebSocketConnectorServer> pair = PORT_TO_REFERENCE_COUNT_AND_SERVER_MAP.get(this.port);
            if (pair == null) {
                return;
            }
            if (((AtomicInteger)pair.getLeft()).decrementAndGet() <= 0) {
                try {
                    ((WebSocketConnectorServer)((Object)pair.getRight())).stop();
                }
                finally {
                    PORT_TO_REFERENCE_COUNT_AND_SERVER_MAP.remove(this.port);
                }
            }
        }
    }

    public synchronized void commit(long requestCommitId, @Nullable EnrichedEvent enrichedEvent) {
        this.commitQueue.offer((Pair<Long, Runnable>)new Pair((Object)requestCommitId, () -> Optional.ofNullable(enrichedEvent).ifPresent(event -> event.decreaseReferenceCount(WebSocketConnector.class.getName(), true))));
        while (!this.commitQueue.isEmpty()) {
            Pair<Long, Runnable> committer = this.commitQueue.peek();
            if ((Long)committer.left <= this.lastCommitId.get()) {
                this.commitQueue.poll();
                continue;
            }
            if ((Long)committer.left != this.lastCommitId.get() + 1L) break;
            ((Runnable)committer.right).run();
            this.lastCommitId.incrementAndGet();
            this.commitQueue.poll();
        }
    }
}

