/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.PipeRequestType;
import org.apache.iotdb.db.pipe.connector.protocol.IoTDBConnectorRequestVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferFilePieceReq
extends TPipeTransferReq {
    private transient String fileName;
    private transient long startWritingOffset;
    private transient byte[] filePiece;

    private PipeTransferFilePieceReq() {
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getStartWritingOffset() {
        return this.startWritingOffset;
    }

    public byte[] getFilePiece() {
        return this.filePiece;
    }

    public static PipeTransferFilePieceReq toTPipeTransferReq(String fileName, long startWritingOffset, byte[] filePiece) throws IOException {
        PipeTransferFilePieceReq filePieceReq = new PipeTransferFilePieceReq();
        filePieceReq.fileName = fileName;
        filePieceReq.startWritingOffset = startWritingOffset;
        filePieceReq.filePiece = filePiece;
        filePieceReq.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        filePieceReq.type = PipeRequestType.TRANSFER_FILE_PIECE.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((String)fileName, (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)startWritingOffset, (OutputStream)outputStream);
            ReadWriteIOUtils.write((Binary)new Binary(filePiece), (OutputStream)outputStream);
            filePieceReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return filePieceReq;
    }

    public static PipeTransferFilePieceReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferFilePieceReq filePieceReq = new PipeTransferFilePieceReq();
        filePieceReq.fileName = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
        filePieceReq.startWritingOffset = ReadWriteIOUtils.readLong((ByteBuffer)transferReq.body);
        filePieceReq.filePiece = ReadWriteIOUtils.readBinary((ByteBuffer)transferReq.body).getValues();
        filePieceReq.version = transferReq.version;
        filePieceReq.type = transferReq.type;
        filePieceReq.body = transferReq.body;
        return filePieceReq;
    }

    public static byte[] toTPipeTransferBytes(String fileName, long startWritingOffset, byte[] filePiece) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_FILE_PIECE.getType(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((String)fileName, (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)startWritingOffset, (OutputStream)outputStream);
                ReadWriteIOUtils.write((Binary)new Binary(filePiece), (OutputStream)outputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferFilePieceReq that = (PipeTransferFilePieceReq)((Object)obj);
        return this.fileName.equals(that.fileName) && this.startWritingOffset == that.startWritingOffset && Arrays.equals(this.filePiece, that.filePiece) && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.startWritingOffset, Arrays.hashCode(this.filePiece), this.version, this.type, this.body);
    }
}

