/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.reponse;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferFilePieceResp
extends TPipeTransferResp {
    public static final long ERROR_END_OFFSET = -1L;
    private long endWritingOffset;

    private PipeTransferFilePieceResp() {
    }

    public long getEndWritingOffset() {
        return this.endWritingOffset;
    }

    public static PipeTransferFilePieceResp toTPipeTransferResp(TSStatus status, long endWritingOffset) throws IOException {
        PipeTransferFilePieceResp filePieceResp = new PipeTransferFilePieceResp();
        filePieceResp.status = status;
        filePieceResp.endWritingOffset = endWritingOffset;
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((long)endWritingOffset, (OutputStream)outputStream);
            filePieceResp.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return filePieceResp;
    }

    public static PipeTransferFilePieceResp toTPipeTransferResp(TSStatus status) {
        PipeTransferFilePieceResp filePieceResp = new PipeTransferFilePieceResp();
        filePieceResp.status = status;
        return filePieceResp;
    }

    public static PipeTransferFilePieceResp fromTPipeTransferResp(TPipeTransferResp transferResp) {
        PipeTransferFilePieceResp filePieceResp = new PipeTransferFilePieceResp();
        filePieceResp.status = transferResp.status;
        if (transferResp.isSetBody()) {
            filePieceResp.endWritingOffset = ReadWriteIOUtils.readLong((ByteBuffer)transferResp.body);
            filePieceResp.body = transferResp.body;
        }
        return filePieceResp;
    }
}

