/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.builder.PipeTransferBatchReqBuilder;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;

public class IoTDBThriftAsyncPipeTransferBatchReqBuilder
extends PipeTransferBatchReqBuilder {
    protected final List<Long> requestCommitIds = new ArrayList<Long>();

    public IoTDBThriftAsyncPipeTransferBatchReqBuilder(PipeParameters parameters) {
        super(parameters);
    }

    public boolean onEvent(TabletInsertionEvent event, long requestCommitId) throws IOException, WALPipeException {
        TPipeTransferReq req = this.buildTabletInsertionReq(event);
        if (this.requestCommitIds.isEmpty() || !this.requestCommitIds.get(this.requestCommitIds.size() - 1).equals(requestCommitId)) {
            this.reqs.add(req);
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).increaseReferenceCount(PipeTransferBatchReqBuilder.class.getName());
            }
            this.events.add(event);
            this.requestCommitIds.add(requestCommitId);
            if (this.firstEventProcessingTime == Long.MIN_VALUE) {
                this.firstEventProcessingTime = System.currentTimeMillis();
            }
            this.bufferSize += (long)req.getBody().length;
        }
        return this.bufferSize >= this.getMaxBatchSizeInBytes() || System.currentTimeMillis() - this.firstEventProcessingTime >= (long)this.maxDelayInMs;
    }

    public void onSuccess() {
        this.reqs.clear();
        this.events.clear();
        this.requestCommitIds.clear();
        this.firstEventProcessingTime = Long.MIN_VALUE;
        this.bufferSize = 0L;
    }

    public List<Event> deepcopyEvents() {
        return new ArrayList<Event>(this.events);
    }

    public List<Long> deepcopyRequestCommitIds() {
        return new ArrayList<Long>(this.requestCommitIds);
    }

    public long getLastCommitId() {
        return this.requestCommitIds.isEmpty() ? -1L : this.requestCommitIds.get(this.requestCommitIds.size() - 1);
    }
}

