/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.runtime;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.extractor.realtime.listener.PipeInsertionDataNodeListener;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipePeriodicalJobExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePeriodicalJobExecutor.class);
    private static final ScheduledExecutorService PERIODICAL_JOB_EXECUTOR = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.PIPE_RUNTIME_PERIODICAL_JOB_EXECUTOR.getName());
    private static final long CRON_EVENT_INJECTOR_INTERVAL_SECONDS = PipeConfig.getInstance().getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds();
    private long cronEventInjectRoundsInterval;
    private static final long MEMORY_EXPANDER_INTERVAL_SECONDS = PipeConfig.getInstance().getPipeMemoryExpanderIntervalSeconds();
    private long memoryExpandRoundsInterval;
    private static final long EXECUTOR_INTERVAL_SECONDS = CRON_EVENT_INJECTOR_INTERVAL_SECONDS;
    private long rounds;
    private Future<?> executorFuture;

    public synchronized void start() {
        if (this.executorFuture == null) {
            this.rounds = 0L;
            this.cronEventInjectRoundsInterval = Math.max(CRON_EVENT_INJECTOR_INTERVAL_SECONDS / EXECUTOR_INTERVAL_SECONDS, 1L);
            this.memoryExpandRoundsInterval = Math.max(MEMORY_EXPANDER_INTERVAL_SECONDS / EXECUTOR_INTERVAL_SECONDS, 1L);
            this.executorFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)PERIODICAL_JOB_EXECUTOR, this::execute, (long)EXECUTOR_INTERVAL_SECONDS, (long)EXECUTOR_INTERVAL_SECONDS, (TimeUnit)TimeUnit.SECONDS);
            LOGGER.info("Pipe periodical job executor is started successfully.");
        }
    }

    private synchronized void execute() {
        ++this.rounds;
        if (this.rounds % this.cronEventInjectRoundsInterval == 0L) {
            PipeInsertionDataNodeListener.getInstance().listenToHeartbeat(false);
        }
        if (this.rounds % this.memoryExpandRoundsInterval == 0L) {
            PipeResourceManager.memory().tryExpandAll();
        }
    }

    public synchronized void stop() {
        if (this.executorFuture != null) {
            this.executorFuture.cancel(false);
            this.executorFuture = null;
            LOGGER.info("Pipe periodical job executor is stopped successfully.");
        }
    }
}

