/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.Channel;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.OpenSsl;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.http.Http2SettingsSpec;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.logging.HttpMessageLogFactory;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.DefaultHttpForwardedHeaderHandler;
import reactor.netty.http.server.HAProxyMessageReader;
import reactor.netty.http.server.HttpRequestDecoderSpec;
import reactor.netty.http.server.HttpServerBind;
import reactor.netty.http.server.HttpServerConfig;
import reactor.netty.http.server.HttpServerFormDecoderProvider;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.HttpServerRoutes;
import reactor.netty.http.server.HttpServerState;
import reactor.netty.http.server.HttpServerTcpConfig;
import reactor.netty.http.server.ProxyProtocolSupportType;
import reactor.netty.http.server.logging.AccessLog;
import reactor.netty.http.server.logging.AccessLogArgProvider;
import reactor.netty.http.server.logging.AccessLogFactory;
import reactor.netty.internal.util.Metrics;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpServer;
import reactor.netty.tcp.TcpServerConfig;
import reactor.netty.transport.ServerTransport;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public abstract class HttpServer
extends ServerTransport<HttpServer, HttpServerConfig> {
    static final Logger log = Loggers.getLogger(HttpServer.class);

    public static HttpServer create() {
        return HttpServerBind.INSTANCE;
    }

    @Deprecated
    public static HttpServer from(TcpServer tcpServer) {
        Objects.requireNonNull(tcpServer, "tcpServer");
        return HttpServerBind.applyTcpServerConfig((TcpServerConfig)tcpServer.configuration());
    }

    public final HttpServer accessLog(boolean enable) {
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).accessLog = null;
        ((HttpServerConfig)dup.configuration()).accessLogEnabled = enable;
        return dup;
    }

    public final HttpServer accessLog(boolean enable, AccessLogFactory accessLogFactory) {
        Objects.requireNonNull(accessLogFactory);
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).accessLog = enable ? accessLogFactory : null;
        ((HttpServerConfig)dup.configuration()).accessLogEnabled = enable;
        return dup;
    }

    @Deprecated
    public final HttpServer accessLog(Function<AccessLogArgProvider, AccessLog> accessLogFactory) {
        Objects.requireNonNull(accessLogFactory, "accessLogFactory");
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).accessLog = accessLogFactory;
        return dup;
    }

    public final HttpServer bindAddress(Supplier<? extends SocketAddress> bindAddressSupplier) {
        return (HttpServer)super.bindAddress(bindAddressSupplier);
    }

    public final HttpServer channelGroup(ChannelGroup channelGroup) {
        return (HttpServer)super.channelGroup(channelGroup);
    }

    public final HttpServer compress(BiPredicate<HttpServerRequest, HttpServerResponse> predicate) {
        Objects.requireNonNull(predicate, "compressionPredicate");
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).compressPredicate = predicate;
        return dup;
    }

    public final HttpServer compress(boolean compressionEnabled) {
        HttpServer dup = (HttpServer)this.duplicate();
        if (compressionEnabled) {
            ((HttpServerConfig)dup.configuration()).minCompressionSize = 0;
        } else {
            ((HttpServerConfig)dup.configuration()).minCompressionSize = -1;
            ((HttpServerConfig)dup.configuration()).compressPredicate = null;
        }
        return dup;
    }

    public final HttpServer compress(int minResponseSize) {
        if (minResponseSize < 0) {
            throw new IllegalArgumentException("minResponseSize must be positive");
        }
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).minCompressionSize = minResponseSize;
        return dup;
    }

    @Deprecated
    public final HttpServer cookieCodec(ServerCookieEncoder encoder) {
        Objects.requireNonNull(encoder, "encoder");
        ServerCookieDecoder decoder = encoder == ServerCookieEncoder.LAX ? ServerCookieDecoder.LAX : ServerCookieDecoder.STRICT;
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).cookieEncoder = encoder;
        ((HttpServerConfig)dup.configuration()).cookieDecoder = decoder;
        return dup;
    }

    @Deprecated
    public final HttpServer cookieCodec(ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
        Objects.requireNonNull(encoder, "encoder");
        Objects.requireNonNull(decoder, "decoder");
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).cookieEncoder = encoder;
        ((HttpServerConfig)dup.configuration()).cookieDecoder = decoder;
        return dup;
    }

    public final HttpServer forwarded(BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> handler) {
        Objects.requireNonNull(handler, "handler");
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).forwardedHeaderHandler = handler;
        return dup;
    }

    public final HttpServer forwarded(boolean forwardedEnabled) {
        if (forwardedEnabled) {
            if (((HttpServerConfig)this.configuration()).forwardedHeaderHandler == DefaultHttpForwardedHeaderHandler.INSTANCE) {
                return this;
            }
            HttpServer dup = (HttpServer)this.duplicate();
            ((HttpServerConfig)dup.configuration()).forwardedHeaderHandler = DefaultHttpForwardedHeaderHandler.INSTANCE;
            return dup;
        }
        if (((HttpServerConfig)this.configuration()).forwardedHeaderHandler != null) {
            HttpServer dup = (HttpServer)this.duplicate();
            ((HttpServerConfig)dup.configuration()).forwardedHeaderHandler = null;
            return dup;
        }
        return this;
    }

    public final HttpServer handle(BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return (HttpServer)this.childObserve(new HttpServerHandle(handler));
    }

    public final HttpServer host(String host) {
        return (HttpServer)super.host(host);
    }

    public final HttpServer http2Settings(Consumer<Http2SettingsSpec.Builder> http2Settings) {
        Objects.requireNonNull(http2Settings, "http2Settings");
        Http2SettingsSpec.Builder builder = Http2SettingsSpec.builder();
        http2Settings.accept(builder);
        Http2SettingsSpec settings = builder.build();
        if (settings.equals(((HttpServerConfig)this.configuration()).http2Settings)) {
            return this;
        }
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).http2Settings = settings;
        return dup;
    }

    public final HttpServer httpFormDecoder(Consumer<HttpServerFormDecoderProvider.Builder> formDecoderBuilder) {
        Objects.requireNonNull(formDecoderBuilder, "formDecoderBuilder");
        HttpServerFormDecoderProvider.Build builder = new HttpServerFormDecoderProvider.Build();
        formDecoderBuilder.accept(builder);
        HttpServerFormDecoderProvider formDecoderProvider = builder.build();
        if (formDecoderProvider.equals(((HttpServerConfig)this.configuration()).formDecoderProvider)) {
            return this;
        }
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).formDecoderProvider = formDecoderProvider;
        return dup;
    }

    public final HttpServer httpMessageLogFactory(HttpMessageLogFactory httpMessageLogFactory) {
        Objects.requireNonNull(httpMessageLogFactory, "httpMessageLogFactory");
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).httpMessageLogFactory = httpMessageLogFactory;
        return dup;
    }

    public final HttpServer httpRequestDecoder(Function<HttpRequestDecoderSpec, HttpRequestDecoderSpec> requestDecoderOptions) {
        Objects.requireNonNull(requestDecoderOptions, "requestDecoderOptions");
        HttpRequestDecoderSpec decoder = requestDecoderOptions.apply(new HttpRequestDecoderSpec()).build();
        if (decoder.equals(((HttpServerConfig)this.configuration()).decoder)) {
            return this;
        }
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).decoder = decoder;
        return dup;
    }

    public final HttpServer idleTimeout(Duration idleTimeout) {
        Objects.requireNonNull(idleTimeout, "idleTimeout");
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).idleTimeout = idleTimeout;
        return dup;
    }

    public final HttpServer mapHandle(BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle) {
        Objects.requireNonNull(mapHandle, "mapHandle");
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).mapHandle = mapHandle;
        return dup;
    }

    public final HttpServer maxKeepAliveRequests(int maxKeepAliveRequests) {
        if (maxKeepAliveRequests < -1 || maxKeepAliveRequests == 0) {
            throw new IllegalArgumentException("maxKeepAliveRequests must be positive or -1");
        }
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).maxKeepAliveRequests = maxKeepAliveRequests;
        return dup;
    }

    public final HttpServer metrics(boolean enable, Function<String, String> uriTagValue) {
        if (enable) {
            if (!Metrics.isMicrometerAvailable() && !Metrics.isTracingAvailable()) {
                throw new UnsupportedOperationException("To enable metrics, you must add the dependencies to `io.micrometer:micrometer-core` and `io.micrometer:micrometer-tracing` to the class path first");
            }
            if (uriTagValue == Function.identity()) {
                log.debug("Metrics are enabled with [uriTagValue=Function#identity]. It is strongly recommended to provide template-like form for the URIs. Without a conversion to a template-like form, each distinct URI leads to the creation of a distinct tag, which takes a lot of memory for the metrics.");
            }
            HttpServer dup = (HttpServer)this.duplicate();
            ((HttpServerConfig)dup.configuration()).metricsRecorder(() -> ((HttpServerConfig)this.configuration()).defaultMetricsRecorder());
            ((HttpServerConfig)dup.configuration()).uriTagValue = uriTagValue;
            return dup;
        }
        if (((HttpServerConfig)this.configuration()).metricsRecorder() != null) {
            HttpServer dup = (HttpServer)this.duplicate();
            ((HttpServerConfig)dup.configuration()).metricsRecorder(null);
            ((HttpServerConfig)dup.configuration()).uriTagValue = null;
            return dup;
        }
        return this;
    }

    public final HttpServer metrics(boolean enable, Supplier<? extends ChannelMetricsRecorder> recorder) {
        return (HttpServer)super.metrics(enable, recorder);
    }

    public final HttpServer metrics(boolean enable, Supplier<? extends ChannelMetricsRecorder> recorder, Function<String, String> uriValue) {
        if (enable) {
            HttpServer dup = (HttpServer)this.duplicate();
            ((HttpServerConfig)dup.configuration()).metricsRecorder(recorder);
            ((HttpServerConfig)dup.configuration()).uriTagValue = uriValue;
            return dup;
        }
        if (((HttpServerConfig)this.configuration()).metricsRecorder() != null) {
            HttpServer dup = (HttpServer)this.duplicate();
            ((HttpServerConfig)dup.configuration()).metricsRecorder(null);
            ((HttpServerConfig)dup.configuration()).uriTagValue = null;
            return dup;
        }
        return this;
    }

    public final HttpServer noSSL() {
        if (((HttpServerConfig)this.configuration()).isSecure()) {
            HttpServer dup = (HttpServer)this.duplicate();
            ((HttpServerConfig)dup.configuration()).sslProvider = null;
            return dup;
        }
        return this;
    }

    public final HttpServer port(int port) {
        return (HttpServer)super.port(port);
    }

    public final HttpServer protocol(HttpProtocol ... supportedProtocols) {
        Objects.requireNonNull(supportedProtocols, "supportedProtocols");
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).protocols(supportedProtocols);
        return dup;
    }

    public final HttpServer proxyProtocol(ProxyProtocolSupportType proxyProtocolSupportType) {
        Objects.requireNonNull(proxyProtocolSupportType, "The parameter: proxyProtocolSupportType must not be null.");
        if (proxyProtocolSupportType == ((HttpServerConfig)this.configuration()).proxyProtocolSupportType) {
            return this;
        }
        if (!(proxyProtocolSupportType != ProxyProtocolSupportType.ON && proxyProtocolSupportType != ProxyProtocolSupportType.AUTO || HAProxyMessageReader.isProxyProtocolAvailable())) {
            throw new UnsupportedOperationException("To enable proxyProtocol, you must add the dependency `io.netty:netty-codec-haproxy` to the class path first");
        }
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).proxyProtocolSupportType = proxyProtocolSupportType;
        return dup;
    }

    public final HttpServer readTimeout(@Nullable Duration readTimeout) {
        if (Objects.equals(readTimeout, ((HttpServerConfig)this.configuration()).readTimeout)) {
            return this;
        }
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).readTimeout = readTimeout;
        return dup;
    }

    public final HttpServer requestTimeout(@Nullable Duration requestTimeout) {
        if (Objects.equals(requestTimeout, ((HttpServerConfig)this.configuration()).requestTimeout)) {
            return this;
        }
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).requestTimeout = requestTimeout;
        return dup;
    }

    public final HttpServer route(Consumer<? super HttpServerRoutes> routesBuilder) {
        Objects.requireNonNull(routesBuilder, "routeBuilder");
        HttpServerRoutes routes = HttpServerRoutes.newRoutes();
        routesBuilder.accept(routes);
        return this.handle(routes);
    }

    public final HttpServer secure(Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder) {
        return this.secure(sslProviderBuilder, false);
    }

    public final HttpServer secure(Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder, boolean redirectHttpToHttps) {
        Objects.requireNonNull(sslProviderBuilder, "sslProviderBuilder");
        HttpServer dup = (HttpServer)this.duplicate();
        SslProvider.SslContextSpec builder = SslProvider.builder();
        sslProviderBuilder.accept((SslProvider.SslContextSpec)builder);
        ((HttpServerConfig)dup.configuration()).sslProvider = ((SslProvider.Builder)builder).build();
        ((HttpServerConfig)dup.configuration()).redirectHttpToHttps = redirectHttpToHttps;
        return dup;
    }

    public final HttpServer secure(SslProvider sslProvider) {
        return this.secure(sslProvider, false);
    }

    public final HttpServer secure(SslProvider sslProvider, boolean redirectHttpToHttps) {
        Objects.requireNonNull(sslProvider, "sslProvider");
        HttpServer dup = (HttpServer)this.duplicate();
        ((HttpServerConfig)dup.configuration()).sslProvider = sslProvider;
        ((HttpServerConfig)dup.configuration()).redirectHttpToHttps = redirectHttpToHttps;
        return dup;
    }

    @Deprecated
    public final HttpServer tcpConfiguration(Function<? super TcpServer, ? extends TcpServer> tcpMapper) {
        Objects.requireNonNull(tcpMapper, "tcpMapper");
        HttpServerTcpConfig tcpServer = new HttpServerTcpConfig(this);
        tcpMapper.apply(tcpServer);
        return tcpServer.httpServer;
    }

    public Mono<Void> warmup() {
        return Mono.when((Publisher[])new Publisher[]{super.warmup(), Mono.fromRunnable(() -> {
            SslProvider provider = ((HttpServerConfig)this.configuration()).sslProvider();
            if (provider != null && !(provider.getSslContext() instanceof JdkSslContext)) {
                OpenSsl.version();
            }
        })});
    }

    public final HttpServer wiretap(boolean enable) {
        return (HttpServer)super.wiretap(enable);
    }

    static final class HttpServerHandle
    implements ConnectionObserver {
        final BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler;

        HttpServerHandle(BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
            this.handler = handler;
        }

        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == HttpServerState.REQUEST_RECEIVED) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format((Channel)connection.channel(), (String)"Handler is being applied: {}"), new Object[]{this.handler});
                    }
                    HttpServerOperations ops = (HttpServerOperations)connection;
                    Publisher<Void> publisher = this.handler.apply(ops, ops);
                    Mono<Void> mono = Mono.deferContextual(ctx -> {
                        ops.currentContext = Context.of((ContextView)ctx);
                        return Mono.fromDirect((Publisher)publisher);
                    });
                    if (ops.mapHandle != null) {
                        mono = ops.mapHandle.apply((Mono<Void>)mono, (Connection)connection);
                    }
                    mono.subscribe(ops.disposeSubscriber());
                }
                catch (Throwable t) {
                    log.error(ReactorNetty.format((Channel)connection.channel(), (String)""), t);
                    connection.channel().close();
                }
            }
        }
    }
}

