<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->
# 社区说明文档
## 社区组织架构
所有抱着推动 Apache IoTDB 前进的共同目的、认同开源文化、遵循相关规范的个人或团体凝聚起来形成了我们的社区。
参考 Apache 基金会的社区理念，我们的社区存在以下四种身份。
- PMC：Project Management Committee，项目管理委员会成员。需通过评选，得到社区的共同认同。
  - 权利：
    - 对于项目重大决定的投票权
    - 获得 PMC 奖杯与礼品
    - Committer的所有权利
  - 义务：
    - 对项目的开发迭代和社区活动的运转提供重要支持
    - 指导项目的开源布道和未来发展方向
    - Committer 的所有义务
- Committer：对项目的前进有较大帮助的社区成员。需通过评选，得到社区的共同认同。
  - 权利：
    - Pull Request approve 权限（binding）
    - Merge Pull Request 权限
    - 发布新版本权限
    - 获得 Committer 奖杯与礼品
  - 义务：
    - 积极参与项目讨论，对项目重大决策给予建议
    - 社区咨询支持
    - 社区开发或宣传任务支持
Contributor：对项目的前进有相关贡献的社区成员。无需通过评选。
- 权利：
  - Pull Request approve 权限
  - 获得 Contributor 奖状与礼品
User： Apache IoTDB 项目的用户。无需通过评选。
- 权利：
  - 获得 User 礼品
## 社区评选规章
### 参与评选的条件
- PMC：
  - 获得现有 PMC 的推荐
  - 技术层面：对项目的整体情况有较全面的了解
  - 发展层面：对时序数据库行业有深刻见地，并能把握项目发展方向
  - 文化层面：对开源文化有较强认同感，为项目的开源布道做出贡献
- Committer：
  - 获得现有 PMC 的推荐
  - 开发者途径
    - 需对对某个功能模块完全了解
  - 开源布道师途径
    - 对项目的开源布道起到实质的推进作用，如沉淀技术文档、提供与宣讲用户案例、积极参与社区交流与活动等
## 社区交流途径
社区拥有丰富的交流途径。目前有以下五种交流途径。可以选择自己适用并倾向的渠道与社区进行交流。

途径一：通过 Slack 进行交流（全英文）
- 适用情况：主要的国际社区交流渠道
途径二：通过微信群、QQ 群进行交流
- 入群方式：微信群——添加好友 qinchuqing，QQ 群——659990460
途经三：通过 Jira 进行交流
- 适用情况：任务（新功能改进、BUG 修复）的管理与交流
- 指南：
  - 创建 Jira 账号（用于任务管理）
  - 创建 Confluence 账号（用于设计文档共建）
  - 账户创建好后，向邮件列表发送一封邮件，包括自我介绍、 Jira id 和 Confluence id，社区 PMC 会为账户添加权限
途径四：通过 GitHub 进行交流
途径五：通过 Apache 邮件列表进行交流（全英文）
- 适用情况：邮件列表是 Apache 唯一指定的开源贡献者的交流渠道，面向全社区的计划、路线和公告等均在邮件列表中沟通。邮件列表 (dev@iotdb.apache.org) 本质上是一个邮箱地址，所有订阅这个邮箱地址的都能收到发往此邮箱的邮件。
- 指南：
  - 发送订阅邮件：向 dev-subscribe@iotdb.apache.org 发送一封邮件，主题内容不限。
  - 确认订阅邮件：完成上一步后，将收到一封来自 iotdb.apache.org 结尾的确认订阅邮件。向该邮件再次发一封主题内容不限的邮件即可确认订阅。

## 社区公约
遵循 Apache 的社区文化，形成以下公约。
保持开放。我们诚邀各位加入我们的社区。除了敏感内容以外，我们期待大家在公开的渠道对项目有关内容展开讨论。这也适用于寻求帮助和项目支持的消息; 不仅仅是群众的支持请求更有可能得到问题的答案，还可以确保社区注意到并纠正回答该问题的人无意间犯的错误。
拥有同理心、热情、友好和耐心。我们共同努力解决矛盾，怀揣善意，并尽最大努力以一种感同身受的方式行动。我们可能会遭受一些挫折，但这并不是进行人身攻击的借口。一个让人感到不舒服或受到威胁的社区不会成为一个卓有成效的社区。 我们应该对打交道的社区成员和社区外部人员都给予尊重。
懂得协作。我们会互相依赖彼此的工作。我们积极向他人说明我们为项目发展所做的工作，解释相关的原理。那么他们可以在我们原有的基础上进一步提高。我们做出的任何决定都会影响到用户和同事，所以我们在做出决定时必须认真考虑可能产生的后果。
有一颗好奇心。没有人能知道一切。尽早提出问题可以避免以后出现很多问题，所以我们鼓励大家提出问题，虽然我们可能会将一些问题引导到更合适的论坛。出于我们优化项目代码的共同目标，那些收到问题的人会积极响应并提供帮助。
注意我们的用词。无论我们是以专业人士还是志愿者的身份参与，我们在所有的互动中都要重视专业精神并对自己的言论负责。
善待他人。不要侮辱或贬低其他参与者。骚扰和排斥行为是不允许的。这包括但不限于:
*针对他人的暴力威胁或语言。
*性别歧视、种族歧视或其他歧视性的笑话和语言。
*发布色情或暴力内容。
*发布(或威胁他人发布)其他人的个人身份信息。
* 分享私人内容，如私人或非公开形式发送的电子邮件，或从未登录的论坛，如IRC频道历史记录。
* 侮辱他人，尤指使用种族主义或性别歧视用语。
* 骚扰性言语和行为。
*不文明用语。
*反复骚扰他人。一般来说，如果别人不希望你继续说下去，那就停下来。
*提倡或鼓励上述任何行为。
注意简洁。请记住，随着时间的推移，成百上千的人会读到你写的东西。写一封简短的电子邮件意味着人们可以尽可能高效地理解对话内容。简短的电子邮件应该尽量表现出感同身受、热情、友好和耐心。当需要一个很长的说明时，请考虑在信息的顶部添加一个摘要。
试着在对话中加入新的想法，这样每封邮件都能给讨论增加一些新的内容。但是请注意，不要忽略已经讨论过的内容。
注意围绕主题，特别是在较长的讨论中。
离开项目时请考虑周全。每个项目都会有人加入有人离开。在有人离开或退出项目时，应该告诉其他成员他们离开了，并通过合适的方式以确保其他成员可以接起他们留下的工作。同时，他们应尊重那些继续参与项目的人，不应该歪曲项目的目标或成就。同样，社区成员也应尊重离开项目的人所做的选择。

## 社区发布新版本流程
### 流程总览
社区发布新版本流程中有两类角色。
角色一：RM （发布经理，Release Manager），是发布新版本的发起人。一般为一个人而非多人承担这个角色。
角色二：社区开发者。社区开发者将对新版本是否发布进行投票。值得提醒的是，不是所有的社区开发者都强制为新版本的发布进行投票。

在我们的开源社区中，发布新版本主要由五步进行。
第一步 - RM 发起提议：由某位开发者自发作为RM （发布经理，Release Manager）提起新版本发布的提议。通过邮件，发出相关提议。邮件发出的提议将对新版本的改进进行充分说明。
第二步 - 社区开发者查看提议：当收到邮件之后，若社区开发者赞同相关提议，可以不回复相关邮件，默认认同提议。若社区开发者对新版本发布提议存在建议或质疑，可以回复邮件进行说明。
第三步 - RM 发布内部测试版（Release Candidate）:当社区开发者的建议得到充分考虑后，RM （发布经理，Release Manager）将发布内部测试版（Release Candidate），通过邮件来让大家进行新版本的测试并投票。
第四步 - 社区开发者进行投票：社区开发者获取到内部测试版（Release Candidate）进行测验。测验后，通过邮件进行投票。
第五步 - 投票通过后 RM 发布正式版本并对外公布：当投票情况符合相关条件，RM发布正式版本，并通过邮件对外公布这个消息。（若投票失败，则通过邮件公布本次发布新版本失败，并在修改后，重新提起发布新版本的流程。此处将不对投票失败情况展开解释。）

### 作为社区开发者，如何验证新版本，来决定是否支持发布？
请见 https://iotdb.apache.org/zh/Development/VoteRelease.html；

#### 如何决定投票是否通过？
依据 Apache Software Foundation 给出的说明，我们将把投票窗口保留 72 小时及以上。当收到至少三票 PMC 赞同票并且赞同票多余反对票的时候，代表投票通过。投票的结果将由 RM （发布经理，Release Manager）汇总。RM 会通过邮件公布结果。

### 作为新手 RM，是否有详细的实践指导？
对于新手的 RM （发布经理，Release Manager），我们提供了详细的实践指导。每一步需要做的事情做了详细的说明，请查看博客《版本发布流程》。