<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at
    
        http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->

# Become a Committer

An Apache IoTDB [committer](https://www.apache.org/foundation/how-it-works.html#committers) has write access to the repository for merging pull requests, but you don’t have to be a code contributor to become a committer. Becoming a committer means that you have the project’s trust. Read the [ASF documentation](https://www.apache.org/dev/committers.html#committer-responsibilities) for more about being a committer in the Apache Software Foundation.

The [PMC](https://www.apache.org/foundation/how-it-works.html#pmc-members) makes someone a committer via nomination, discussion, and then majority vote. We use data from as many sources as possible to inform our reasoning. Here are some examples:

- IoTDB expert and evangelist (documentations, blogs, etc..)
- Public events
- Firsthand PMC testimonials

The PMC has assembled the following set of guidelines for becoming a committer.

## An Apache IoTDBcommitter…

### Takes many forms

There are many actions other than coding that build the trust we place in a committer - code review, design discussion, user support, community outreach, improving infrastructure, documentation, project management, etc.

### Knows, upholds, and reinforces the Apache Software Foundation code of conduct

See the [ASF documentation](https://www.apache.org/foundation/policies/conduct.html). In particular, they manifestly strive to:

- Be open
- Be empathetic
- Be welcoming
- Be friendly
- Be patient
- Be collaborative
- Be inquisitive
- Be careful in the words that they choose

### Knows, upholds, and reinforces the responsibilities of an Apache Software Foundation committer

See the [ASF documentation](https://www.apache.org/dev/committers.html#committer-responsibilities).

- They help create a product that will outlive the interest of any particular volunteer (including themselves)
- They grow and maintain the health of the Apache community
- They help out with surrounding work, such as the website & documentation
- They help users
- They can be trusted to decide when code is ready for release, or when to ask someone else to make the judgment
- They can be trusted to decide when to merge code (if a code contributor) or when to ask someone else to make the judgment

### Knows, upholds, and reinforces the IoTDB community’s practices

- They have a proven commitment to the project
- They share their intentions with the community
- They accept and integrate community feedback in their plans, designs, code, etc.
- They earnestly try to make IoTDB better with their contributions
- In particular, if a code contributor:
  - They earnestly try to make IoTDB better with their own code
  - They earnestly try to make IoTDB better with code review
  - They accept and integrate feedback on their code
  - They know, follow, and enforce IoTDB's practices while reviewing/merging code - style, documentation, testing, backward compatibility, etc.


The code of conduct is derived from [Apache Beam](https://beam.apache.org/contribute/become-a-committer/).