/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class Like<T extends Comparable<T>>
implements Filter {
    private static final long serialVersionUID = 2171102599229260789L;
    protected String value;
    protected FilterType filterType;
    protected Pattern pattern;

    private Like() {
    }

    public Like(String value, FilterType filterType) {
        this.value = value;
        this.filterType = filterType;
        try {
            String unescapeValue = this.unescapeString(value);
            String specialRegexStr = ".^$*+?{}[]|()";
            StringBuilder patternStrBuild = new StringBuilder();
            patternStrBuild.append("^");
            for (int i = 0; i < unescapeValue.length(); ++i) {
                String ch = String.valueOf(unescapeValue.charAt(i));
                if (specialRegexStr.contains(ch)) {
                    ch = "\\" + unescapeValue.charAt(i);
                }
                if (i == 0 || i > 0 && !"\\".equals(String.valueOf(unescapeValue.charAt(i - 1))) || i >= 2 && "\\\\".equals(patternStrBuild.substring(patternStrBuild.length() - 2, patternStrBuild.length()))) {
                    String replaceStr = ch.replace("%", ".*?").replace("_", ".");
                    patternStrBuild.append(replaceStr);
                    continue;
                }
                patternStrBuild.append(ch);
            }
            patternStrBuild.append("$");
            this.pattern = Pattern.compile(patternStrBuild.toString());
        }
        catch (PatternSyntaxException e) {
            throw new PatternSyntaxException("Regular expression error", value.toString(), e.getIndex());
        }
    }

    @Override
    public boolean satisfy(Statistics statistics) {
        return true;
    }

    @Override
    public boolean satisfy(long time, Object value) {
        if (this.filterType != FilterType.VALUE_FILTER) {
            return false;
        }
        return this.pattern.matcher(value.toString()).find();
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        return true;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        return true;
    }

    @Override
    public Filter copy() {
        return new Like<T>(this.value, this.filterType);
    }

    @Override
    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.write(this.getSerializeId().ordinal());
            outputStream.write(this.filterType.ordinal());
            ReadWriteIOUtils.writeObject((Object)this.value, outputStream);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to serialize outputStream of type:", ex);
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.filterType = FilterType.values()[buffer.get()];
        this.value = ReadWriteIOUtils.readString(buffer);
    }

    public String toString() {
        return (Object)((Object)this.filterType) + " is " + this.value;
    }

    @Override
    public FilterSerializeId getSerializeId() {
        return FilterSerializeId.LIKE;
    }

    public String unescapeString(String value) {
        String out = "";
        for (int i = 0; i < value.length(); ++i) {
            String ch = String.valueOf(value.charAt(i));
            if ("\\".equals(ch)) {
                if (i >= value.length() - 1) continue;
                String nextChar = String.valueOf(value.charAt(i + 1));
                if ("%".equals(nextChar) || "_".equals(nextChar) || "\\".equals(nextChar)) {
                    out = out + ch;
                }
                if (!"\\".equals(nextChar)) continue;
                ++i;
                continue;
            }
            out = out + ch;
        }
        return out;
    }
}

