/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class Between<T extends Comparable<T>>
implements Filter {
    private static final long serialVersionUID = -537390606419370764L;
    protected T value1;
    protected T value2;
    protected boolean not;
    protected FilterType filterType;

    public Between() {
    }

    public Between(T value1, T value2, FilterType filterType, boolean not) {
        this.value1 = value1;
        this.value2 = value2;
        this.filterType = filterType;
        this.not = not;
    }

    @Override
    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.write(this.getSerializeId().ordinal());
            outputStream.write(this.filterType.ordinal());
            ReadWriteIOUtils.write((Boolean)this.not, (OutputStream)outputStream);
            ReadWriteIOUtils.writeObject(this.value1, outputStream);
            ReadWriteIOUtils.writeObject(this.value2, outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.filterType = FilterType.values()[buffer.get()];
        this.not = ReadWriteIOUtils.readBool(buffer);
        this.value1 = (Comparable)ReadWriteIOUtils.readObject(buffer);
        this.value2 = (Comparable)ReadWriteIOUtils.readObject(buffer);
    }

    @Override
    public FilterSerializeId getSerializeId() {
        return FilterSerializeId.BETWEEN;
    }

    @Override
    public boolean satisfy(Statistics statistics) {
        if (this.filterType == FilterType.TIME_FILTER) {
            long time1 = (Long)this.value1;
            long time2 = (Long)this.value2;
            if (this.not) {
                return statistics.getStartTime() < time1 || statistics.getEndTime() > time2;
            }
            return statistics.getEndTime() >= time1 || statistics.getStartTime() <= time2;
        }
        if (statistics.getType() == TSDataType.TEXT || statistics.getType() == TSDataType.BOOLEAN) {
            return true;
        }
        if (this.not) {
            return ((Comparable)statistics.getMinValue()).compareTo(this.value1) < 0 || ((Comparable)statistics.getMaxValue()).compareTo(this.value2) > 0;
        }
        return ((Comparable)statistics.getMaxValue()).compareTo(this.value1) >= 0 && ((Comparable)statistics.getMinValue()).compareTo(this.value2) <= 0;
    }

    @Override
    public boolean satisfy(long time, Object value) {
        Object v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : value;
        return (this.value1.compareTo((Comparable)((Comparable)v)) <= 0 && ((Comparable)v).compareTo(this.value2) <= 0) ^ this.not;
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        if (this.filterType == FilterType.TIME_FILTER) {
            long time1 = (Long)this.value1;
            long time2 = (Long)this.value2;
            if (this.not) {
                return startTime < time1 || endTime > time2;
            }
            return endTime >= time1 && startTime <= time2;
        }
        return true;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        if (this.filterType == FilterType.TIME_FILTER) {
            long time1 = (Long)this.value1;
            long time2 = (Long)this.value2;
            if (this.not) {
                return endTime < time1 || startTime > time2;
            }
            return startTime >= time1 && endTime <= time2;
        }
        return true;
    }

    @Override
    public Filter copy() {
        return new Between<T>(this.value1, this.value2, this.filterType, this.not);
    }
}

