/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.Configuration;
import com.bugsnag.Stackframe;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

class ThreadState {
    private final Configuration config;
    private final Thread thread;
    private final StackTraceElement[] stackTraceElements;
    private Boolean errorReportingThread;

    ThreadState(Configuration config, Thread thread, StackTraceElement[] stackTraceElements) {
        this.config = config;
        this.thread = thread;
        this.stackTraceElements = stackTraceElements;
    }

    static List<ThreadState> getLiveThreads(Configuration config, Thread currentThread, Map<Thread, StackTraceElement[]> liveThreads, Throwable exc) {
        long crashingThreadId = currentThread.getId();
        if (!liveThreads.containsKey(currentThread)) {
            liveThreads.put(currentThread, currentThread.getStackTrace());
        }
        if (exc != null) {
            liveThreads.put(currentThread, exc.getStackTrace());
        }
        Object[] keys = liveThreads.keySet().toArray();
        Arrays.sort(keys, new Comparator<Object>(){

            @Override
            public int compare(Object first, Object second) {
                return Long.valueOf(((Thread)first).getId()).compareTo(((Thread)second).getId());
            }
        });
        ArrayList<ThreadState> threads = new ArrayList<ThreadState>();
        for (Object key : keys) {
            Thread thread = (Thread)key;
            ThreadState threadState = new ThreadState(config, thread, liveThreads.get(thread));
            threads.add(threadState);
            if (threadState.getId() != crashingThreadId) continue;
            threadState.setErrorReportingThread(true);
        }
        return threads;
    }

    @JsonProperty(value="id")
    public long getId() {
        return this.thread.getId();
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.thread.getName();
    }

    @JsonProperty(value="stacktrace")
    public List<Stackframe> getStacktrace() {
        return Stackframe.getStacktrace(this.config, this.stackTraceElements);
    }

    @JsonProperty(value="errorReportingThread")
    public Boolean isErrorReportingThread() {
        return this.errorReportingThread;
    }

    public void setErrorReportingThread(Boolean errorReportingThread) {
        this.errorReportingThread = errorReportingThread;
    }
}

