/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Queue;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.server.metrics.RaftLogMetricsBase;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogCache;
import org.apache.ratis.util.DataQueue;

public class SegmentedRaftLogMetrics
extends RaftLogMetricsBase {
    public static final String RAFT_LOG_FLUSH_TIME = "flushTime";
    public static final String RAFT_LOG_FLUSH_COUNT = "flushCount";
    public static final String RAFT_LOG_SYNC_TIME = "syncTime";
    public static final String RAFT_LOG_DATA_QUEUE_SIZE = "dataQueueSize";
    public static final String RAFT_LOG_WORKER_QUEUE_SIZE = "workerQueueSize";
    public static final String RAFT_LOG_SYNC_BATCH_SIZE = "syncBatchSize";
    public static final String RAFT_LOG_CACHE_MISS_COUNT = "cacheMissCount";
    public static final String RAFT_LOG_CACHE_HIT_COUNT = "cacheHitCount";
    public static final String RAFT_LOG_CACHE_CLOSED_SEGMENTS_NUM = "closedSegmentsNum";
    public static final String RAFT_LOG_CACHE_CLOSED_SEGMENTS_SIZE_IN_BYTES = "closedSegmentsSizeInBytes";
    public static final String RAFT_LOG_CACHE_OPEN_SEGMENT_SIZE_IN_BYTES = "openSegmentSizeInBytes";
    public static final String RAFT_LOG_APPEND_ENTRY_LATENCY = "appendEntryLatency";
    public static final String RAFT_LOG_TASK_QUEUE_TIME = "enqueuedTime";
    public static final String RAFT_LOG_TASK_ENQUEUE_DELAY = "queueingDelay";
    public static final String RAFT_LOG_TASK_EXECUTION_TIME = "%sExecutionTime";
    public static final String RAFT_LOG_APPEND_ENTRY_COUNT = "appendEntryCount";
    public static final String RAFT_LOG_PURGE_METRIC = "purgeLog";
    public static final String RAFT_LOG_STATEMACHINE_DATA_WRITE_TIMEOUT_COUNT = "numStateMachineDataWriteTimeout";
    public static final String RAFT_LOG_STATEMACHINE_DATA_READ_TIMEOUT_COUNT = "numStateMachineDataReadTimeout";
    public static final String RAFT_LOG_READ_ENTRY_LATENCY = "readEntryLatency";
    public static final String RAFT_LOG_LOAD_SEGMENT_LATENCY = "segmentLoadLatency";

    public SegmentedRaftLogMetrics(RaftGroupMemberId serverId) {
        super(serverId);
    }

    public void addDataQueueSizeGauge(DataQueue queue) {
        this.registry.gauge(RAFT_LOG_DATA_QUEUE_SIZE, () -> () -> ((DataQueue)queue).getNumElements());
    }

    public void addClosedSegmentsNum(SegmentedRaftLogCache cache) {
        this.registry.gauge(RAFT_LOG_CACHE_CLOSED_SEGMENTS_NUM, () -> () -> cache.getCachedSegmentNum());
    }

    public void addClosedSegmentsSizeInBytes(SegmentedRaftLogCache cache) {
        this.registry.gauge(RAFT_LOG_CACHE_CLOSED_SEGMENTS_SIZE_IN_BYTES, () -> () -> cache.getClosedSegmentsSizeInBytes());
    }

    public void addOpenSegmentSizeInBytes(SegmentedRaftLogCache cache) {
        this.registry.gauge(RAFT_LOG_CACHE_OPEN_SEGMENT_SIZE_IN_BYTES, () -> () -> cache.getOpenSegmentSizeInBytes());
    }

    public void addLogWorkerQueueSizeGauge(Queue queue) {
        this.registry.gauge(RAFT_LOG_WORKER_QUEUE_SIZE, () -> () -> queue.size());
    }

    public void addFlushBatchSizeGauge(MetricRegistry.MetricSupplier<Gauge> supplier) {
        this.registry.gauge(RAFT_LOG_SYNC_BATCH_SIZE, supplier);
    }

    private Timer getTimer(String timerName) {
        return this.registry.timer(timerName);
    }

    public Timer getFlushTimer() {
        return this.getTimer(RAFT_LOG_FLUSH_TIME);
    }

    public Timer getRaftLogSyncTimer() {
        return this.getTimer(RAFT_LOG_SYNC_TIME);
    }

    public void onRaftLogCacheHit() {
        this.registry.counter(RAFT_LOG_CACHE_HIT_COUNT).inc();
    }

    public void onRaftLogCacheMiss() {
        this.registry.counter(RAFT_LOG_CACHE_MISS_COUNT).inc();
    }

    public void onRaftLogFlush() {
        this.registry.counter(RAFT_LOG_FLUSH_COUNT).inc();
    }

    public void onRaftLogAppendEntry() {
        this.registry.counter(RAFT_LOG_APPEND_ENTRY_COUNT).inc();
    }

    public Timer getRaftLogAppendEntryTimer() {
        return this.getTimer(RAFT_LOG_APPEND_ENTRY_LATENCY);
    }

    public Timer getRaftLogQueueTimer() {
        return this.getTimer(RAFT_LOG_TASK_QUEUE_TIME);
    }

    public Timer getRaftLogEnqueueDelayTimer() {
        return this.getTimer(RAFT_LOG_TASK_ENQUEUE_DELAY);
    }

    public Timer getRaftLogTaskExecutionTimer(String taskName) {
        return this.getTimer(String.format(RAFT_LOG_TASK_EXECUTION_TIME, taskName));
    }

    @Override
    public Timer getRaftLogReadEntryTimer() {
        return this.getTimer(RAFT_LOG_READ_ENTRY_LATENCY);
    }

    @Override
    public Timer getRaftLogLoadSegmentTimer() {
        return this.getTimer(RAFT_LOG_LOAD_SEGMENT_LATENCY);
    }

    public Timer getRaftLogPurgeTimer() {
        return this.getTimer(RAFT_LOG_PURGE_METRIC);
    }

    public void onStateMachineDataWriteTimeout() {
        this.registry.counter(RAFT_LOG_STATEMACHINE_DATA_WRITE_TIMEOUT_COUNT).inc();
    }

    public void onStateMachineDataReadTimeout() {
        this.registry.counter(RAFT_LOG_STATEMACHINE_DATA_READ_TIMEOUT_COUNT).inc();
    }
}

