/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.utils.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResultListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResultListener.class);
    protected final boolean wait;
    protected volatile Status status;
    protected volatile Exception cause;

    public AbstractResultListener(boolean wait) {
        this.wait = wait;
        this.status = Status.RUNNING;
        this.cause = null;
    }

    public synchronized AbstractResultListener succeed() {
        this.status = Status.SUCCESS;
        if (this.wait) {
            this.notifyAll();
        }
        return this;
    }

    public synchronized AbstractResultListener fail(Exception e) {
        this.status = Status.FAILURE;
        this.cause = e;
        if (this.wait) {
            this.notifyAll();
        }
        return this;
    }

    public synchronized Status waitForResult() {
        if (this.wait) {
            while (this.status == Status.RUNNING) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted when waiting for result.", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        return this.status;
    }

    public Exception getCause() {
        return this.cause;
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        RUNNING;

    }
}

