/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.recover;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.iotdb.db.wal.io.WALMetaData;
import org.apache.iotdb.db.wal.io.WALWriter;

public class WALRecoverWriter {
    private final File logFile;

    public WALRecoverWriter(File logFile) {
        this.logFile = logFile;
    }

    public void recover(WALMetaData metaData) throws IOException {
        int truncateSize;
        if (this.logFile.length() < (long)WALWriter.MAGIC_STRING_BYTES) {
            truncateSize = 0;
        } else {
            if (this.readTailMagic().equals("WAL")) {
                return;
            }
            truncateSize = metaData.getBuffersSize().stream().mapToInt(Integer::intValue).sum();
        }
        try (FileChannel channel = FileChannel.open(this.logFile.toPath(), StandardOpenOption.APPEND);){
            channel.truncate(truncateSize);
        }
        try (WALWriter walWriter = new WALWriter(this.logFile);){
            walWriter.updateMetaData(metaData);
        }
    }

    private String readTailMagic() throws IOException {
        try (FileChannel channel = FileChannel.open(this.logFile.toPath(), StandardOpenOption.READ);){
            ByteBuffer magicStringBytes = ByteBuffer.allocate(WALWriter.MAGIC_STRING_BYTES);
            channel.read(magicStringBytes, channel.size() - (long)WALWriter.MAGIC_STRING_BYTES);
            magicStringBytes.flip();
            String string = new String(magicStringBytes.array());
            return string;
        }
    }
}

