/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.windowing.window;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.utils.Binary;

public class EvictableBatchList {
    private static int internalBatchSize = 1000000;
    private final TSDataType dataType;
    private List<BatchData> batchList;
    private int size;
    private int actualOuterIndexAt0;

    public EvictableBatchList(TSDataType dataType) {
        this.dataType = dataType;
        this.batchList = new ArrayList<BatchData>();
        this.size = 0;
        this.actualOuterIndexAt0 = 0;
    }

    public void putInt(long t, int v) {
        if (this.size % internalBatchSize == 0) {
            this.batchList.add(new BatchData(this.dataType));
        }
        this.batchList.get(this.size / internalBatchSize - this.actualOuterIndexAt0).putInt(t, v);
        ++this.size;
    }

    public void putLong(long t, long v) {
        if (this.size % internalBatchSize == 0) {
            this.batchList.add(new BatchData(this.dataType));
        }
        this.batchList.get(this.size / internalBatchSize - this.actualOuterIndexAt0).putLong(t, v);
        ++this.size;
    }

    public void putFloat(long t, float v) {
        if (this.size % internalBatchSize == 0) {
            this.batchList.add(new BatchData(this.dataType));
        }
        this.batchList.get(this.size / internalBatchSize - this.actualOuterIndexAt0).putFloat(t, v);
        ++this.size;
    }

    public void putDouble(long t, double v) {
        if (this.size % internalBatchSize == 0) {
            this.batchList.add(new BatchData(this.dataType));
        }
        this.batchList.get(this.size / internalBatchSize - this.actualOuterIndexAt0).putDouble(t, v);
        ++this.size;
    }

    public void putBoolean(long t, boolean v) {
        if (this.size % internalBatchSize == 0) {
            this.batchList.add(new BatchData(this.dataType));
        }
        this.batchList.get(this.size / internalBatchSize - this.actualOuterIndexAt0).putBoolean(t, v);
        ++this.size;
    }

    public void putBinary(long t, Binary v) {
        if (this.size % internalBatchSize == 0) {
            this.batchList.add(new BatchData(this.dataType));
        }
        this.batchList.get(this.size / internalBatchSize - this.actualOuterIndexAt0).putBinary(t, v);
        ++this.size;
    }

    public long getTimeByIndex(int index) {
        return this.batchList.get(index / internalBatchSize - this.actualOuterIndexAt0).getTimeByIndex(index % internalBatchSize);
    }

    public int getIntByIndex(int index) {
        return this.batchList.get(index / internalBatchSize - this.actualOuterIndexAt0).getIntByIndex(index % internalBatchSize);
    }

    public long getLongByIndex(int index) {
        return this.batchList.get(index / internalBatchSize - this.actualOuterIndexAt0).getLongByIndex(index % internalBatchSize);
    }

    public float getFloatByIndex(int index) {
        return this.batchList.get(index / internalBatchSize - this.actualOuterIndexAt0).getFloatByIndex(index % internalBatchSize);
    }

    public double getDoubleByIndex(int index) {
        return this.batchList.get(index / internalBatchSize - this.actualOuterIndexAt0).getDoubleByIndex(index % internalBatchSize);
    }

    public boolean getBooleanByIndex(int index) {
        return this.batchList.get(index / internalBatchSize - this.actualOuterIndexAt0).getBooleanByIndex(index % internalBatchSize);
    }

    public Binary getBinaryByIndex(int index) {
        return this.batchList.get(index / internalBatchSize - this.actualOuterIndexAt0).getBinaryByIndex(index % internalBatchSize);
    }

    public void setEvictionUpperBound(int evictionUpperBound) {
        int outerEvictionUpperBound = evictionUpperBound / internalBatchSize;
        if (this.actualOuterIndexAt0 < outerEvictionUpperBound) {
            this.doEviction(outerEvictionUpperBound);
        }
    }

    private void doEviction(int outerEvictionUpperBound) {
        this.batchList = new ArrayList<BatchData>(this.batchList.subList(outerEvictionUpperBound - this.actualOuterIndexAt0, this.batchList.size()));
        this.actualOuterIndexAt0 = outerEvictionUpperBound;
    }

    public int size() {
        return this.size;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public static void setInternalBatchSize(int internalBatchSize) {
        EvictableBatchList.internalBatchSize = internalBatchSize;
    }
}

