/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.datastructure.LongTVList;
import org.apache.iotdb.db.utils.datastructure.TimSort;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class TimLongTVList
extends LongTVList
implements TimSort {
    private long[][] sortedTimestamps;
    private long pivotTime;
    private long[][] sortedValues;
    private long pivotValue;

    @Override
    public void sort() {
        if (this.sortedTimestamps == null || this.sortedTimestamps.length < PrimitiveArrayManager.getArrayRowCount(this.rowCount)) {
            this.sortedTimestamps = (long[][])PrimitiveArrayManager.createDataListsByType(TSDataType.INT64, this.rowCount);
        }
        if (this.sortedValues == null || this.sortedValues.length < PrimitiveArrayManager.getArrayRowCount(this.rowCount)) {
            this.sortedValues = (long[][])PrimitiveArrayManager.createDataListsByType(TSDataType.INT64, this.rowCount);
        }
        if (!this.sorted) {
            this.sort(0, this.rowCount);
        }
        this.clearSortedValue();
        this.clearSortedTime();
        this.sorted = true;
    }

    @Override
    public void tim_set(int src, int dest) {
        this.set(src, dest);
    }

    @Override
    public void set(int src, int dest) {
        long srcT = this.getTime(src);
        long srcV = this.getLong(src);
        this.set(dest, srcT, srcV);
    }

    @Override
    public void setToSorted(int src, int dest) {
        this.sortedTimestamps[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getTime(src);
        this.sortedValues[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getLong(src);
    }

    @Override
    public void saveAsPivot(int pos) {
        this.pivotTime = this.getTime(pos);
        this.pivotValue = this.getLong(pos);
    }

    @Override
    public void setFromSorted(int src, int dest) {
        this.set(dest, this.sortedTimestamps[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE], this.sortedValues[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE]);
    }

    @Override
    public void setPivotTo(int pos) {
        this.set(pos, this.pivotTime, this.pivotValue);
    }

    @Override
    public void clearSortedTime() {
        if (this.sortedTimestamps != null) {
            this.sortedTimestamps = null;
        }
    }

    @Override
    public void clearSortedValue() {
        if (this.sortedValues != null) {
            this.sortedValues = null;
        }
    }

    @Override
    public int compare(int idx1, int idx2) {
        long t1 = this.getTime(idx1);
        long t2 = this.getTime(idx2);
        return Long.compare(t1, t2);
    }

    @Override
    public void reverseRange(int lo, int hi) {
        --hi;
        while (lo < hi) {
            long loT = this.getTime(lo);
            long loV = this.getLong(lo);
            long hiT = this.getTime(hi);
            long hiV = this.getLong(hi);
            this.set(lo++, hiT, hiV);
            this.set(hi--, loT, loV);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.clearSortedTime();
        this.clearSortedValue();
    }
}

