/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.transport.server;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.sync.PipeDataLoadException;
import org.apache.iotdb.commons.sync.utils.SyncPathUtil;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.pipedata.TsFilePipeData;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiverManager {
    private static Logger logger = LoggerFactory.getLogger(ReceiverManager.class);
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final ThreadLocal<Long> currentConnectionId = new ThreadLocal();
    private final Map<Long, TSyncIdentityInfo> connectionIdToIdentityInfoMap = new ConcurrentHashMap<Long, TSyncIdentityInfo>();
    private final Map<Long, Map<String, Long>> connectionIdToStartIndexRecord = new ConcurrentHashMap<Long, Map<String, Long>>();
    private final AtomicLong connectionIdGenerator = new AtomicLong();

    private CheckResult checkStartIndexValid(File file, long startIndex) throws IOException {
        long localIndex = this.getCurrentFileStartIndex(file.getAbsolutePath());
        if (localIndex < 0L && file.exists()) {
            localIndex = file.length();
            this.recordStartIndex(file, localIndex);
        }
        if (localIndex < 0L && startIndex != 0L) {
            logger.error("The start index {} of data sync is not valid. The file is not exist and start index should equal to 0).", (Object)startIndex);
            return new CheckResult(false, "0");
        }
        if (localIndex >= 0L && localIndex != startIndex) {
            logger.error("The start index {} of data sync is not valid. The start index of the file should equal to {}.", (Object)startIndex, (Object)localIndex);
            return new CheckResult(false, String.valueOf(localIndex));
        }
        return new CheckResult(true, "0");
    }

    private void recordStartIndex(File file, long position) {
        Long id = this.currentConnectionId.get();
        if (id != null) {
            Map map = this.connectionIdToStartIndexRecord.computeIfAbsent(id, i -> new ConcurrentHashMap());
            map.put(file.getAbsolutePath(), position);
        }
    }

    public TSStatus handshake(TSyncIdentityInfo identityInfo) {
        logger.debug("Invoke handshake method from client ip = {}", (Object)identityInfo.address);
        if (!this.verifyIPSegment(this.config.getIpWhiteList(), identityInfo.address)) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPESERVER_ERROR, (String)"Sender IP is not in the white list of receiver IP and synchronization tasks are not allowed.");
        }
        if (!this.config.getIoTDBMajorVersion(identityInfo.version).equals(this.config.getIoTDBMajorVersion())) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPESERVER_ERROR, (String)String.format("Version mismatch: the sender <%s>, the receiver <%s>", identityInfo.version, this.config.getIoTDBVersion()));
        }
        if (!new File(SyncPathUtil.getFileDataDirPath((TSyncIdentityInfo)identityInfo)).exists()) {
            new File(SyncPathUtil.getFileDataDirPath((TSyncIdentityInfo)identityInfo)).mkdirs();
        }
        this.createConnection(identityInfo);
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"");
    }

    private boolean verifyIPSegment(String ipWhiteList, String ipAddress) {
        String[] ipSegments;
        for (String IPsegment : ipSegments = ipWhiteList.split(",")) {
            int subnetMask = Integer.parseInt(IPsegment.substring(IPsegment.indexOf(47) + 1));
            if (!this.verifyIP(IPsegment = IPsegment.substring(0, IPsegment.indexOf(47)), ipAddress, subnetMask)) continue;
            return true;
        }
        return false;
    }

    private boolean verifyIP(String ipSegment, String ipAddress, int subnetMark) {
        String[] ipSplits = ipSegment.split("\\.");
        DecimalFormat df = new DecimalFormat("00000000");
        StringBuilder ipSegmentBuilder = new StringBuilder();
        for (String IPsplit : ipSplits) {
            ipSegmentBuilder.append(df.format(Integer.parseInt(Integer.toBinaryString(Integer.parseInt(IPsplit)))));
        }
        String ipSegmentBinary = ipSegmentBuilder.toString();
        ipSegmentBinary = ipSegmentBinary.substring(0, subnetMark);
        ipSplits = ipAddress.split("\\.");
        StringBuilder ipAddressBuilder = new StringBuilder();
        for (String IPsplit : ipSplits) {
            ipAddressBuilder.append(df.format(Integer.parseInt(Integer.toBinaryString(Integer.parseInt(IPsplit)))));
        }
        String ipAddressBinary = ipAddressBuilder.toString();
        ipAddressBinary = ipAddressBinary.substring(0, subnetMark);
        return ipAddressBinary.equals(ipSegmentBinary);
    }

    public TSStatus transportPipeData(ByteBuffer buff) throws TException {
        PipeData pipeData;
        TSyncIdentityInfo identityInfo = this.getCurrentTSyncIdentityInfo();
        if (identityInfo == null) {
            throw new TException("Thrift connection is not alive.");
        }
        logger.debug("Invoke transportPipeData method from client ip = {}", (Object)identityInfo.address);
        String fileDir = SyncPathUtil.getFileDataDirPath((TSyncIdentityInfo)identityInfo);
        try {
            int length = buff.capacity();
            byte[] byteArray = new byte[length];
            buff.get(byteArray);
            pipeData = PipeData.createPipeData(byteArray);
            if (pipeData instanceof TsFilePipeData) {
                TsFilePipeData tsFilePipeData = (TsFilePipeData)pipeData;
                tsFilePipeData.setStorageGroupName(identityInfo.getStorageGroup());
                this.handleTsFilePipeData(tsFilePipeData, fileDir);
            }
        }
        catch (IOException | IllegalPathException e) {
            logger.error("Pipe data transport error, {}", (Object)e.getMessage());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPESERVER_ERROR, (String)("Pipe data transport error, " + e.getMessage()));
        }
        logger.info("Start load pipeData with serialize number {} and type {},value={}", new Object[]{pipeData.getSerialNumber(), pipeData.getType(), pipeData});
        try {
            pipeData.createLoader().load();
            logger.info("Load pipeData with serialize number {} successfully.", (Object)pipeData.getSerialNumber());
        }
        catch (PipeDataLoadException e) {
            logger.error("Fail to load pipeData because {}.", (Object)e.getMessage());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPESERVER_ERROR, (String)("Fail to load pipeData because " + e.getMessage()));
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"");
    }

    public TSStatus transportFile(TSyncTransportMetaInfo metaInfo, ByteBuffer buff) throws TException {
        TSyncIdentityInfo identityInfo = this.getCurrentTSyncIdentityInfo();
        if (identityInfo == null) {
            throw new TException("Thrift connection is not alive.");
        }
        logger.debug("Invoke transportData method from client ip = {}", (Object)identityInfo.address);
        String fileDir = SyncPathUtil.getFileDataDirPath((TSyncIdentityInfo)identityInfo);
        String fileName = metaInfo.fileName;
        long startIndex = metaInfo.startIndex;
        File file = new File(fileDir, fileName + ".patch");
        try {
            CheckResult result = this.checkStartIndexValid(new File(fileDir, fileName), startIndex);
            if (!result.isResult()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SYNC_FILE_REBASE, (String)result.getIndex());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SYNC_FILE_ERROR, (String)e.getMessage());
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            int length = buff.capacity();
            randomAccessFile.seek(startIndex);
            byte[] byteArray = new byte[length];
            buff.get(byteArray);
            randomAccessFile.write(byteArray);
            this.recordStartIndex(new File(fileDir, fileName), startIndex + (long)length);
            logger.debug("Sync " + fileName + " start at " + startIndex + " to " + (startIndex + (long)length) + " is done.");
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SYNC_FILE_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"");
    }

    private void handleTsFilePipeData(TsFilePipeData tsFilePipeData, String fileDir) {
        File dir = new File(fileDir);
        String tsFileName = tsFilePipeData.getTsFileName();
        File[] targetFiles = dir.listFiles((dir1, name) -> name.startsWith(tsFileName) && name.endsWith(".patch"));
        if (targetFiles != null) {
            for (File targetFile : targetFiles) {
                File newFile = new File(dir, targetFile.getName().substring(0, targetFile.getName().length() - ".patch".length()));
                targetFile.renameTo(newFile);
            }
        }
        tsFilePipeData.setParentDirPath(dir.getAbsolutePath());
    }

    private boolean checkConnection() {
        return this.currentConnectionId.get() != null;
    }

    private TSyncIdentityInfo getCurrentTSyncIdentityInfo() {
        Long id = this.currentConnectionId.get();
        if (id != null) {
            return this.connectionIdToIdentityInfoMap.get(id);
        }
        return null;
    }

    private long getCurrentFileStartIndex(String absolutePath) {
        Map<String, Long> map;
        Long id = this.currentConnectionId.get();
        if (id != null && (map = this.connectionIdToStartIndexRecord.get(id)) != null && map.containsKey(absolutePath)) {
            return map.get(absolutePath);
        }
        return -1L;
    }

    private void createConnection(TSyncIdentityInfo identityInfo) {
        long connectionId = this.connectionIdGenerator.incrementAndGet();
        this.currentConnectionId.set(connectionId);
        this.connectionIdToIdentityInfoMap.put(connectionId, identityInfo);
    }

    public void handleClientExit() {
        if (this.checkConnection()) {
            long id = this.currentConnectionId.get();
            this.connectionIdToIdentityInfoMap.remove(id);
            this.connectionIdToIdentityInfoMap.remove(id);
            this.currentConnectionId.remove();
        }
    }

    public List<TSyncIdentityInfo> getAllTSyncIdentityInfos() {
        return new ArrayList<TSyncIdentityInfo>(this.connectionIdToIdentityInfoMap.values());
    }

    private class CheckResult {
        boolean result;
        String index;

        public CheckResult(boolean result, String index) {
            this.result = result;
            this.index = index;
        }

        public boolean isResult() {
            return this.result;
        }

        public String getIndex() {
            return this.index;
        }
    }
}

