/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.ShutdownException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.commons.sync.pipe.TsFilePipeInfo;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.commons.sync.utils.SyncPathUtil;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeInfo;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.qp.physical.sys.CreatePipeSinkPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPipePlan;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.sync.common.ClusterSyncInfoFetcher;
import org.apache.iotdb.db.sync.common.ISyncInfoFetcher;
import org.apache.iotdb.db.sync.common.LocalSyncInfoFetcher;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginManager;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginRegister;
import org.apache.iotdb.db.sync.externalpipe.ExternalPipeStatus;
import org.apache.iotdb.db.sync.sender.manager.ISyncManager;
import org.apache.iotdb.db.sync.sender.pipe.ExternalPipeSink;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.pipe.TsFilePipe;
import org.apache.iotdb.db.sync.transport.client.SenderManager;
import org.apache.iotdb.db.sync.transport.server.ReceiverManager;
import org.apache.iotdb.db.utils.sync.SyncPipeUtil;
import org.apache.iotdb.pipe.external.api.IExternalPipeSinkWriterFactory;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncService
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(SyncService.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private Pipe runningPipe;
    private ExtPipePluginManager extPipePluginManager;
    private ISyncInfoFetcher syncInfoFetcher;
    private final ReceiverManager receiverManager = new ReceiverManager();

    private SyncService() {
        this.syncInfoFetcher = config.isClusterMode() ? ClusterSyncInfoFetcher.getInstance() : LocalSyncInfoFetcher.getInstance();
    }

    public static SyncService getInstance() {
        return SyncServiceHolder.INSTANCE;
    }

    public TSStatus handshake(TSyncIdentityInfo identityInfo) {
        return this.receiverManager.handshake(identityInfo);
    }

    public TSStatus transportFile(TSyncTransportMetaInfo metaInfo, ByteBuffer buff) throws TException {
        return this.receiverManager.transportFile(metaInfo, buff);
    }

    public TSStatus transportPipeData(ByteBuffer buff) throws TException {
        return this.receiverManager.transportPipeData(buff);
    }

    public void handleClientExit() {
        this.receiverManager.handleClientExit();
    }

    public PipeSink getPipeSink(String name) throws PipeSinkException {
        return this.syncInfoFetcher.getPipeSink(name);
    }

    public void addPipeSink(CreatePipeSinkPlan plan) throws PipeSinkException {
        TSStatus status = this.syncInfoFetcher.addPipeSink(plan);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeSinkException(status.message);
        }
    }

    public void addPipeSink(CreatePipeSinkStatement createPipeSinkStatement) throws PipeSinkException {
        TSStatus status = this.syncInfoFetcher.addPipeSink(createPipeSinkStatement);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeSinkException(status.message);
        }
    }

    public void dropPipeSink(String name) throws PipeSinkException {
        TSStatus status = this.syncInfoFetcher.dropPipeSink(name);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeSinkException(status.message);
        }
    }

    public List<PipeSink> getAllPipeSink() {
        return this.syncInfoFetcher.getAllPipeSinks();
    }

    public synchronized void addPipe(PipeInfo pipeInfo) throws PipeException {
        PipeSink runningPipeSink;
        logger.info("Execute CREATE PIPE {}", (Object)pipeInfo.getPipeName());
        long currentTime = DateTimeUtils.currentTime();
        if (pipeInfo instanceof TsFilePipeInfo && ((TsFilePipeInfo)pipeInfo).getDataStartTimestamp() > currentTime) {
            throw new PipeException(String.format("Start time %s is later than current time %s, this is not supported yet.", DateTimeUtils.convertLongToDate(((TsFilePipeInfo)pipeInfo).getDataStartTimestamp()), DateTimeUtils.convertLongToDate(currentTime)));
        }
        TSStatus status = this.syncInfoFetcher.addPipe(pipeInfo);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.message);
        }
        try {
            runningPipeSink = this.getPipeSink(pipeInfo.getPipeSinkName());
        }
        catch (PipeSinkException e) {
            logger.error("failed to add PIPE because {}", (Object)e.getMessage(), (Object)e);
            throw new PipeException(String.format("failed to add PIPE because %s", e.getMessage()));
        }
        this.runningPipe = SyncPipeUtil.parseTPipeSinkInfoAsPipeSink(pipeInfo, runningPipeSink);
        if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.ExternalPipe) {
            this.startExternalPipeManager(false);
        }
    }

    public synchronized void stopPipe(String pipeName) throws PipeException {
        TSStatus status;
        logger.info("Execute stop PIPE {}", (Object)pipeName);
        this.checkRunningPipeExistAndName(pipeName);
        if (this.runningPipe.getStatus() == PipeStatus.RUNNING) {
            if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
                this.runningPipe.stop();
            } else {
                if (this.extPipePluginManager != null) {
                    try {
                        String extPipeSinkTypeName = ((ExternalPipeSink)this.runningPipe.getPipeSink()).getExtPipeSinkTypeName();
                        this.extPipePluginManager.stopExtPipe(extPipeSinkTypeName);
                    }
                    catch (Exception e) {
                        throw new PipeException("Failed to stop externalPipeProcessor. " + e.getMessage());
                    }
                }
                this.runningPipe.stop();
            }
        }
        if ((status = this.syncInfoFetcher.stopPipe(pipeName)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.message);
        }
    }

    public synchronized void startPipe(String pipeName) throws PipeException {
        TSStatus status;
        logger.info("Execute start PIPE {}", (Object)pipeName);
        this.checkRunningPipeExistAndName(pipeName);
        if (this.runningPipe.getStatus() == PipeStatus.STOP) {
            if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
                this.runningPipe.start();
            } else {
                this.runningPipe.start();
                this.startExternalPipeManager(true);
            }
        }
        if ((status = this.syncInfoFetcher.startPipe(pipeName)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.message);
        }
    }

    public synchronized void dropPipe(String pipeName) throws PipeException {
        logger.info("Execute drop PIPE {}", (Object)pipeName);
        this.checkRunningPipeExistAndName(pipeName);
        if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.IoTDB) {
            this.runningPipe.drop();
        } else {
            if (this.extPipePluginManager != null) {
                String extPipeSinkTypeName = ((ExternalPipeSink)this.runningPipe.getPipeSink()).getExtPipeSinkTypeName();
                this.extPipePluginManager.dropExtPipe(extPipeSinkTypeName);
                this.extPipePluginManager = null;
            }
            this.runningPipe.drop();
        }
        TSStatus status = this.syncInfoFetcher.dropPipe(pipeName);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.message);
        }
    }

    public List<PipeInfo> getAllPipeInfos() {
        return this.syncInfoFetcher.getAllPipeInfos();
    }

    private void checkRunningPipeExistAndName(String pipeName) throws PipeException {
        if (this.runningPipe == null || this.runningPipe.getStatus() == PipeStatus.DROP) {
            throw new PipeException("There is no existing PIPE.");
        }
        if (!this.runningPipe.getName().equals(pipeName)) {
            throw new PipeException(String.format("PIPE %s is %s, please retry after drop it.", this.runningPipe.getName(), this.runningPipe.getStatus()));
        }
    }

    public synchronized void recordMessage(PipeMessage message) {
        if (this.runningPipe == null || this.runningPipe.getStatus() == PipeStatus.DROP) {
            logger.info(String.format("No running PIPE for message %s.", message));
            return;
        }
        TSStatus status = null;
        switch (message.getType()) {
            case ERROR: {
                logger.error("{}", (Object)message);
                status = this.syncInfoFetcher.recordMsg(this.runningPipe.getName(), this.runningPipe.getCreateTime(), message);
                try {
                    this.stopPipe(this.runningPipe.getName());
                }
                catch (PipeException e) {
                    logger.error(String.format("Stop PIPE %s when meeting error in sender service.", this.runningPipe.getName()), (Throwable)e);
                }
                break;
            }
            case WARN: {
                logger.warn("{}", (Object)message);
                status = this.syncInfoFetcher.recordMsg(this.runningPipe.getName(), this.runningPipe.getCreateTime(), message);
                break;
            }
            default: {
                logger.error(String.format("Unknown message type: %s", message));
            }
        }
        if (status != null && status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            logger.error(String.format("Failed to record message: %s", message));
        }
    }

    public List<TShowPipeInfo> showPipe(String pipeName) {
        TShowPipeInfo tPipeInfo;
        boolean showAll = StringUtils.isEmpty((CharSequence)pipeName);
        ArrayList<TShowPipeInfo> list = new ArrayList<TShowPipeInfo>();
        for (PipeInfo pipe : SyncService.getInstance().getAllPipeInfos()) {
            if (!showAll && !pipeName.equals(pipe.getPipeName())) continue;
            tPipeInfo = new TShowPipeInfo(pipe.getCreateTime(), pipe.getPipeName(), "sender", pipe.getPipeSinkName(), pipe.getStatus().name(), pipe.getMessageType().name());
            list.add(tPipeInfo);
        }
        for (TSyncIdentityInfo identityInfo : this.receiverManager.getAllTSyncIdentityInfos()) {
            if (!showAll && !pipeName.equals(identityInfo.getPipeName())) continue;
            tPipeInfo = new TShowPipeInfo(identityInfo.getCreateTime(), identityInfo.getPipeName(), "receiver", identityInfo.getAddress(), PipeStatus.RUNNING.name(), PipeMessage.PipeMessageType.NORMAL.name());
            list.add(tPipeInfo);
        }
        return list;
    }

    public void showPipe(ShowPipePlan plan, ListDataSet listDataSet) {
        boolean showAll = "".equals(plan.getPipeName());
        for (PipeInfo pipe : SyncService.getInstance().getAllPipeInfos()) {
            if (!showAll && !plan.getPipeName().equals(pipe.getPipeName())) continue;
            try {
                RowRecord record = new RowRecord(0L);
                record.addField((Object)Binary.valueOf((String)DateTimeUtils.convertLongToDate(pipe.getCreateTime())), TSDataType.TEXT);
                record.addField((Object)Binary.valueOf((String)pipe.getPipeName()), TSDataType.TEXT);
                record.addField((Object)Binary.valueOf((String)"sender"), TSDataType.TEXT);
                record.addField((Object)Binary.valueOf((String)pipe.getPipeSinkName()), TSDataType.TEXT);
                record.addField((Object)Binary.valueOf((String)pipe.getStatus().name()), TSDataType.TEXT);
                PipeSink pipeSink = this.syncInfoFetcher.getPipeSink(pipe.getPipeSinkName());
                if (pipeSink.getType() == PipeSink.PipeSinkType.ExternalPipe) {
                    String extPipeType;
                    ExternalPipeStatus externalPipeStatus;
                    ExtPipePluginManager extPipePluginManager = SyncService.getInstance().getExternalPipeManager();
                    if (extPipePluginManager != null && (externalPipeStatus = extPipePluginManager.getExternalPipeStatus(extPipeType = ((ExternalPipeSink)pipeSink).getExtPipeSinkTypeName())) != null) {
                        record.addField((Object)Binary.valueOf((String)(externalPipeStatus.getWriterInvocationFailures().toString() + ";" + externalPipeStatus.getWriterStatuses().toString())), TSDataType.TEXT);
                    }
                } else {
                    record.addField((Object)Binary.valueOf((String)pipe.getMessageType().name()), TSDataType.TEXT);
                }
                listDataSet.putRecord(record);
            }
            catch (Exception e) {
                logger.error("failed to show pipe [{}] because {}", (Object)pipe.getPipeName(), (Object)e.getMessage());
            }
        }
        List<TSyncIdentityInfo> identityInfoList = this.receiverManager.getAllTSyncIdentityInfos();
        for (TSyncIdentityInfo identityInfo : identityInfoList) {
            RowRecord record = new RowRecord(0L);
            record.addField((Object)Binary.valueOf((String)DateTimeUtils.convertLongToDate(identityInfo.getCreateTime())), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)identityInfo.getPipeName()), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)"receiver"), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)identityInfo.getAddress()), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)PipeStatus.RUNNING.name()), TSDataType.TEXT);
            record.addField((Object)Binary.valueOf((String)PipeMessage.PipeMessageType.NORMAL.name()), TSDataType.TEXT);
            listDataSet.putRecord(record);
        }
    }

    private void startExternalPipeManager(boolean startExtPipe) throws PipeException {
        if (!(this.runningPipe instanceof TsFilePipe)) {
            logger.error("startExternalPipeManager(), runningPipe is not TsFilePipe. " + this.runningPipe);
            return;
        }
        PipeSink pipeSink = this.runningPipe.getPipeSink();
        if (!(pipeSink instanceof ExternalPipeSink)) {
            logger.error("startExternalPipeManager(), pipeSink is not ExternalPipeSink." + pipeSink);
            return;
        }
        String extPipeSinkTypeName = ((ExternalPipeSink)pipeSink).getExtPipeSinkTypeName();
        IExternalPipeSinkWriterFactory externalPipeSinkWriterFactory = ExtPipePluginRegister.getInstance().getWriteFactory(extPipeSinkTypeName);
        if (externalPipeSinkWriterFactory == null) {
            logger.error(String.format("startExternalPipeManager(), can not found ExternalPipe plugin for %s.", extPipeSinkTypeName));
            throw new PipeException("Can not found ExternalPipe plugin for " + extPipeSinkTypeName + ".");
        }
        if (this.extPipePluginManager == null) {
            this.extPipePluginManager = new ExtPipePluginManager((TsFilePipe)this.runningPipe);
        }
        if (startExtPipe) {
            try {
                this.extPipePluginManager.startExtPipe(extPipeSinkTypeName, ((ExternalPipeSink)pipeSink).getSinkParams());
            }
            catch (IOException e) {
                logger.error("Failed to start External Pipe: {}.", (Object)extPipeSinkTypeName, (Object)e);
                throw new PipeException("Failed to start External Pipe: " + extPipeSinkTypeName + ". " + e.getMessage());
            }
        }
    }

    public ExtPipePluginManager getExternalPipeManager() {
        return this.extPipePluginManager;
    }

    public void start() throws StartupException {
        ExtPipePluginRegister extPipePluginRegister = ExtPipePluginRegister.getInstance();
        if (extPipePluginRegister == null) {
            throw new StartupException("Load ExternalPipe Plugin error.");
        }
        logger.info("Load {} ExternalPipe Plugin: {}", (Object)extPipePluginRegister.getAllPluginName().size(), extPipePluginRegister.getAllPluginName());
        File senderLog = new File(SyncPathUtil.getSysDir(), "syncService.log");
        if (senderLog.exists()) {
            try {
                this.recover();
            }
            catch (Exception e) {
                logger.error("Recover from disk error.", (Throwable)e);
                throw new StartupException((Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.runningPipe != null && !PipeStatus.DROP.equals((Object)this.runningPipe.getStatus())) {
            try {
                this.runningPipe.close();
            }
            catch (PipeException e) {
                logger.warn(String.format("Stop PIPE %s error when stop Sender Service.", this.runningPipe.getName()), (Throwable)e);
            }
        }
    }

    public void shutdown(long milliseconds) throws ShutdownException {
        if (this.runningPipe != null && !PipeStatus.DROP.equals((Object)this.runningPipe.getStatus())) {
            try {
                this.runningPipe.stop();
                this.runningPipe.close();
            }
            catch (PipeException e) {
                logger.warn(String.format("Stop pipe %s error when shutdown Sender Service.", this.runningPipe.getName()), (Throwable)e);
                throw new ShutdownException((Throwable)e);
            }
        }
    }

    public ServiceType getID() {
        return ServiceType.SYNC_SERVICE;
    }

    private void recover() throws IOException, PipeException, PipeSinkException {
        PipeInfo runningPipeInfo = this.syncInfoFetcher.getRunningPipeInfo();
        if (runningPipeInfo == null || PipeStatus.DROP.equals((Object)runningPipeInfo.getStatus())) {
            return;
        }
        this.runningPipe = SyncPipeUtil.parseTPipeSinkInfoAsPipeSink(runningPipeInfo, this.syncInfoFetcher.getPipeSink(runningPipeInfo.getPipeSinkName()));
        switch (runningPipeInfo.getStatus()) {
            case RUNNING: {
                this.runningPipe.start();
                break;
            }
            case STOP: {
                this.runningPipe.stop();
                break;
            }
            case DROP: {
                this.runningPipe.drop();
                break;
            }
            default: {
                throw new IOException(String.format("Can not recognize running pipe status %s.", runningPipeInfo.getStatus()));
            }
        }
        if (this.runningPipe.getPipeSink().getType() == PipeSink.PipeSinkType.ExternalPipe) {
            this.startExternalPipeManager(this.runningPipe.getStatus() == PipeStatus.RUNNING);
        }
    }

    public List<ISyncManager> getOrCreateSyncManager(String dataRegionId) {
        ArrayList<ISyncManager> syncManagerList = new ArrayList<ISyncManager>();
        if (this.runningPipe != null) {
            syncManagerList.add(this.runningPipe.getOrCreateSyncManager(dataRegionId));
        }
        return syncManagerList;
    }

    public synchronized void unregisterDataRegion(String dataRegionId) {
        if (this.runningPipe != null) {
            this.runningPipe.unregisterDataRegion(dataRegionId);
        }
    }

    public SenderManager getSenderManager() {
        return this.runningPipe.getSenderManager();
    }

    private static class SyncServiceHolder {
        private static final SyncService INSTANCE = new SyncService();

        private SyncServiceHolder() {
        }
    }
}

