/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.util.Objects;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.service.AbstractThriftServiceThread;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class DataNodeInternalRPCServiceMetrics
implements IMetricSet {
    AbstractThriftServiceThread thriftServiceThread;

    public DataNodeInternalRPCServiceMetrics(AbstractThriftServiceThread thriftServiceThread) {
        this.thriftServiceThread = thriftServiceThread;
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.getOrCreateAutoGauge(Metric.THRIFT_ACTIVE_THREADS.toString(), MetricLevel.CORE, (Object)this.thriftServiceThread, AbstractThriftServiceThread::getActiveThreadCount, new String[]{Tag.NAME.toString(), ThreadName.DATANODE_INTERNAL_RPC_SERVICE.getName()});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, Metric.THRIFT_ACTIVE_THREADS.toString(), new String[]{Tag.NAME.toString(), ThreadName.DATANODE_INTERNAL_RPC_SERVICE.getName()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataNodeInternalRPCServiceMetrics that = (DataNodeInternalRPCServiceMetrics)o;
        return Objects.equals(this.thriftServiceThread, that.thriftServiceThread);
    }

    public int hashCode() {
        return Objects.hash(this.thriftServiceThread);
    }
}

