/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import java.io.IOException;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.query.externalsort.adapter.ByTimestampReaderAdapter;
import org.apache.iotdb.db.query.reader.chunk.ChunkDataIterator;
import org.apache.iotdb.db.query.reader.chunk.DiskChunkReaderByTimestamp;
import org.apache.iotdb.db.query.reader.chunk.MemChunkReader;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;

public class ChunkReaderWrap {
    private ChunkReaderType type;
    private Filter filter;
    private ChunkMetadata chunkMetaData;
    private IChunkLoader chunkLoader;
    private ReadOnlyMemChunk readOnlyMemChunk;

    protected ChunkReaderWrap() {
    }

    public ChunkReaderWrap(ChunkMetadata metaData, IChunkLoader chunkLoader, Filter filter) {
        this.type = ChunkReaderType.DISK_CHUNK;
        this.chunkMetaData = metaData;
        this.chunkLoader = chunkLoader;
        this.filter = filter;
    }

    public ChunkReaderWrap(ReadOnlyMemChunk readOnlyMemChunk, Filter filter) {
        this.type = ChunkReaderType.MEM_CHUNK;
        this.readOnlyMemChunk = readOnlyMemChunk;
        this.filter = filter;
    }

    public IPointReader getIPointReader() throws IOException {
        if (this.type.equals((Object)ChunkReaderType.DISK_CHUNK)) {
            Chunk chunk = this.chunkLoader.loadChunk(this.chunkMetaData);
            ChunkReader chunkReader = new ChunkReader(chunk, this.filter);
            return new ChunkDataIterator((IChunkReader)chunkReader);
        }
        return new MemChunkReader(this.readOnlyMemChunk, this.filter);
    }

    public IReaderByTimestamp getIReaderByTimestamp() throws IOException {
        if (this.type.equals((Object)ChunkReaderType.DISK_CHUNK)) {
            Chunk chunk = this.chunkLoader.loadChunk(this.chunkMetaData);
            ChunkReader chunkReader = new ChunkReader(chunk, null);
            return new DiskChunkReaderByTimestamp(chunkReader);
        }
        return new ByTimestampReaderAdapter(this.readOnlyMemChunk.getPointReader());
    }

    public String getMeasurementUid() {
        if (this.chunkMetaData != null) {
            return this.chunkMetaData.getMeasurementUid();
        }
        return null;
    }

    static enum ChunkReaderType {
        DISK_CHUNK,
        MEM_CHUNK;

    }
}

