/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.externalsort.adapter;

import java.io.IOException;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class ByTimestampReaderAdapter
implements IReaderByTimestamp {
    private IPointReader pointReader;
    private boolean hasCached;
    private TimeValuePair pair;
    private long currentTime = Long.MIN_VALUE;

    public ByTimestampReaderAdapter(IPointReader pointReader) {
        this.pointReader = pointReader;
    }

    @Override
    public Object[] getValuesInTimestamps(long[] timestamps, int length) throws IOException {
        Object[] result = new Object[length];
        block0: for (int i = 0; i < length; ++i) {
            if (timestamps[i] < this.currentTime) {
                throw new IOException("time must be increasing when use ReaderByTimestamp");
            }
            this.currentTime = timestamps[i];
            if (this.hasCached && this.pair.getTimestamp() >= this.currentTime) {
                if (this.pair.getTimestamp() != this.currentTime) continue;
                this.hasCached = false;
                result[i] = this.pair.getValue().getValue();
                continue;
            }
            while (this.pointReader.hasNextTimeValuePair()) {
                this.pair = this.pointReader.nextTimeValuePair();
                if (this.pair.getTimestamp() == this.currentTime) {
                    result[i] = this.pair.getValue().getValue();
                    continue block0;
                }
                if (this.pair.getTimestamp() <= this.currentTime) continue;
                this.hasCached = true;
                result[i] = null;
                continue block0;
            }
        }
        return result;
    }
}

