/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByTimeDataSet;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.common.TimeRange;

public abstract class GroupByTimeEngineDataSet
extends GroupByTimeDataSet {
    public GroupByTimeEngineDataSet() {
    }

    public GroupByTimeEngineDataSet(QueryContext context, GroupByTimePlan groupByTimePlan) {
        super(context, groupByTimePlan);
    }

    @Override
    public RowRecord nextWithoutConstraint() throws IOException {
        if (!this.hasCachedTimeInterval) {
            throw new IOException("need to call hasNext() before calling next() in GroupByTimeEngineDataSet.");
        }
        this.hasCachedTimeInterval = false;
        this.curAggregateResults = this.getNextAggregateResult();
        return this.constructRowRecord(this.curAggregateResults);
    }

    protected abstract AggregateResult[] getNextAggregateResult() throws IOException;

    protected RowRecord constructRowRecord(AggregateResult[] aggregateResultList) {
        RowRecord record = this.leftCRightO ? new RowRecord(this.curAggrTimeRange.getMin()) : new RowRecord(this.curAggrTimeRange.getMax() - 1L);
        for (AggregateResult res : aggregateResultList) {
            if (res == null) {
                record.addField(null);
                continue;
            }
            record.addField(res.getResult(), res.getResultDataType());
        }
        return record;
    }

    protected boolean isEndCal() {
        if (this.curPreAggrTimeRange.getMin() == -1L) {
            return true;
        }
        return this.ascending ? this.curPreAggrTimeRange.getMin() >= this.curAggrTimeRange.getMax() : this.curPreAggrTimeRange.getMax() <= this.curAggrTimeRange.getMin();
    }

    protected void updatePreAggrInterval() {
        TimeRange retPerAggrTimeRange = null;
        if (this.preAggrWindowIterator.hasNextTimeRange()) {
            retPerAggrTimeRange = this.preAggrWindowIterator.nextTimeRange();
        }
        this.curPreAggrTimeRange = retPerAggrTimeRange != null ? retPerAggrTimeRange : new TimeRange(-1L, -1L);
    }

    public AggregateResult[] getCurAggregateResults() {
        return this.curAggregateResults;
    }
}

