/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;

public class ShowDevicesPlan
extends ShowPlan {
    private boolean hasSgCol;

    public ShowDevicesPlan() {
        super(ShowPlan.ShowContentType.DEVICES);
    }

    public ShowDevicesPlan(PartialPath path) {
        super(ShowPlan.ShowContentType.DEVICES, path);
    }

    public ShowDevicesPlan(PartialPath path, int limit, int offset, boolean hasSgCol) {
        super(ShowPlan.ShowContentType.DEVICES, path, limit, offset);
        this.hasSgCol = hasSgCol;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        outputStream.write(PhysicalPlan.PhysicalPlanType.SHOW_DEVICES.ordinal());
        this.putString(outputStream, this.path.getFullPath());
        outputStream.writeInt(this.limit);
        outputStream.writeInt(this.offset);
        outputStream.writeLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.path = new PartialPath(this.readString(buffer));
        this.limit = buffer.getInt();
        this.offset = buffer.getInt();
        this.index = buffer.getLong();
    }

    public boolean hasSgCol() {
        return this.hasSgCol;
    }
}

