/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class LoadDataPlan
extends PhysicalPlan {
    private final String inputFilePath;
    private final String measureType;

    public LoadDataPlan(String inputFilePath, String measureType) {
        super(Operator.OperatorType.LOAD_DATA);
        this.inputFilePath = inputFilePath;
        this.measureType = measureType;
    }

    public List<PartialPath> getPaths() {
        return this.measureType != null ? Collections.singletonList(new PartialPath(new String[]{this.measureType})) : Collections.emptyList();
    }

    public String getInputFilePath() {
        return this.inputFilePath;
    }

    public String getMeasureType() {
        return this.measureType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadDataPlan)) {
            return false;
        }
        LoadDataPlan that = (LoadDataPlan)o;
        return Objects.equals(this.getInputFilePath(), that.getInputFilePath()) && Objects.equals(this.getMeasureType(), that.getMeasureType());
    }

    public int hashCode() {
        return Objects.hash(this.getInputFilePath(), this.getMeasureType());
    }
}

