/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IActivateTemplatePlan;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivateTemplatePlan
extends PhysicalPlan
implements IActivateTemplatePlan {
    private static final Logger logger = LoggerFactory.getLogger(ActivateTemplatePlan.class);
    PartialPath prefixPath;

    public ActivateTemplatePlan() {
        super(Operator.OperatorType.ACTIVATE_TEMPLATE);
    }

    public ActivateTemplatePlan(PartialPath prefixPath) {
        super(Operator.OperatorType.ACTIVATE_TEMPLATE);
        this.prefixPath = prefixPath;
    }

    public List<PartialPath> getPaths() {
        return null;
    }

    @Override
    public PartialPath getPrefixPath() {
        return this.prefixPath;
    }

    @Override
    public void setPrefixPath(PartialPath prefixPath) {
        this.prefixPath = prefixPath;
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.ACTIVATE_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.prefixPath.getFullPath(), (ByteBuffer)buffer);
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        String pathString = this.readString(buffer);
        try {
            this.prefixPath = new PartialPath(pathString);
        }
        catch (IllegalPathException e) {
            logger.error("Failed to deserialize device {} from buffer", (Object)pathString);
        }
        this.index = buffer.getLong();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.ACTIVATE_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.prefixPath.getFullPath(), (OutputStream)stream);
        stream.writeLong(this.index);
    }
}

