/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.utils.WALWriteUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DeletePlan
extends PhysicalPlan
implements WALEntryValue {
    private static final int FIXED_SERIALIZED_SIZE = 29;
    private long deleteStartTime;
    private long deleteEndTime;
    private List<PartialPath> paths = new ArrayList<PartialPath>();
    private DataRegion.TimePartitionFilter partitionFilter;

    public DeletePlan() {
        super(Operator.OperatorType.DELETE);
    }

    public DeletePlan(long startTime, long endTime, PartialPath path) {
        super(Operator.OperatorType.DELETE);
        this.deleteStartTime = startTime;
        this.deleteEndTime = endTime;
        this.paths.add(path);
    }

    public DeletePlan(long startTime, long endTime, List<PartialPath> paths) {
        super(Operator.OperatorType.DELETE);
        this.deleteStartTime = startTime;
        this.deleteEndTime = endTime;
        this.paths = paths;
    }

    public long getDeleteStartTime() {
        return this.deleteStartTime;
    }

    public void setDeleteStartTime(long delTime) {
        this.deleteStartTime = delTime;
    }

    public long getDeleteEndTime() {
        return this.deleteEndTime;
    }

    public void setDeleteEndTime(long delTime) {
        this.deleteEndTime = delTime;
    }

    public void addPath(PartialPath path) {
        this.paths.add(path);
    }

    public void addPaths(List<PartialPath> paths) {
        this.paths.addAll(paths);
    }

    public List<PartialPath> getPaths() {
        return this.paths;
    }

    @Override
    public void setPaths(List<PartialPath> paths) {
        this.paths = paths;
    }

    public DataRegion.TimePartitionFilter getPartitionFilter() {
        return this.partitionFilter;
    }

    public void setPartitionFilter(DataRegion.TimePartitionFilter partitionFilter) {
        this.partitionFilter = partitionFilter;
    }

    public int hashCode() {
        return Objects.hash(this.deleteStartTime, this.deleteEndTime, this.paths);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletePlan that = (DeletePlan)o;
        return this.deleteStartTime == that.deleteStartTime && this.deleteEndTime == that.deleteEndTime && Objects.equals(this.paths, that.paths);
    }

    @Override
    public int serializedSize() {
        int size = 29;
        for (PartialPath path : this.paths) {
            size += ReadWriteIOUtils.sizeToWrite((String)path.getFullPath());
        }
        return size;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.DELETE.ordinal();
        stream.writeByte((byte)type);
        stream.writeLong(this.deleteStartTime);
        stream.writeLong(this.deleteEndTime);
        stream.writeInt(this.paths.size());
        for (PartialPath path : this.paths) {
            this.putString(stream, path.getFullPath());
        }
        stream.writeLong(this.index);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.DELETE.ordinal();
        buffer.put((byte)type);
        buffer.putLong(this.deleteStartTime);
        buffer.putLong(this.deleteEndTime);
        buffer.putInt(this.paths.size());
        for (PartialPath path : this.paths) {
            this.putString(buffer, path.getFullPath());
        }
        buffer.putLong(this.index);
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        int type = PhysicalPlan.PhysicalPlanType.DELETE.ordinal();
        buffer.put((byte)type);
        buffer.putLong(this.deleteStartTime);
        buffer.putLong(this.deleteEndTime);
        buffer.putInt(this.paths.size());
        for (PartialPath path : this.paths) {
            WALWriteUtils.write(path.getFullPath(), buffer);
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(DataInputStream stream) throws IOException, IllegalPathException {
        this.deleteStartTime = stream.readLong();
        this.deleteEndTime = stream.readLong();
        int pathSize = stream.readInt();
        this.paths = new ArrayList<PartialPath>();
        for (int i = 0; i < pathSize; ++i) {
            this.paths.add(new PartialPath(ReadWriteIOUtils.readString((InputStream)stream)));
        }
        this.index = stream.readLong();
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.deleteStartTime = buffer.getLong();
        this.deleteEndTime = buffer.getLong();
        int pathSize = buffer.getInt();
        this.paths = new ArrayList<PartialPath>();
        for (int i = 0; i < pathSize; ++i) {
            this.paths.add(new PartialPath(this.readString(buffer)));
        }
        this.index = buffer.getLong();
    }
}

