/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.trigger.executor.TriggerEvent;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTriggerPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class CreateTriggerOperator
extends Operator {
    private String triggerName;
    private TriggerEvent event;
    private PartialPath fullPath;
    private String className;
    private final Map<String, String> attributes;

    public CreateTriggerOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.CREATE_TRIGGER;
        this.attributes = new HashMap<String, String>();
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public void setEvent(TriggerEvent event) {
        this.event = event;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setFullPath(PartialPath fullPath) {
        this.fullPath = fullPath;
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public TriggerEvent getEvent() {
        return this.event;
    }

    public String getClassName() {
        return this.className;
    }

    public PartialPath getFullPath() {
        return this.fullPath;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        return new CreateTriggerPlan(this.triggerName, this.event, this.fullPath, this.className, this.attributes);
    }
}

