/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class CreateTimeSeriesOperator
extends Operator {
    private PartialPath path;
    private String alias;
    private TSDataType dataType;
    private TSEncoding encoding;
    private CompressionType compressor;
    private Map<String, String> props = null;
    private Map<String, String> attributes = null;
    private Map<String, String> tags = null;

    public CreateTimeSeriesOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.CREATE_TIMESERIES;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    public TSEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(TSEncoding encoding) {
        this.encoding = encoding;
    }

    public void setCompressor(CompressionType compressor) {
        this.compressor = compressor;
    }

    public CompressionType getCompressor() {
        return this.compressor;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        if (this.tags != null && !this.tags.isEmpty() && this.attributes != null && !this.attributes.isEmpty()) {
            for (String tagKey : this.tags.keySet()) {
                if (!this.attributes.containsKey(tagKey)) continue;
                throw new QueryProcessException(String.format("Tag and attribute shouldn't have the same property key [%s]", tagKey));
            }
        }
        return new CreateTimeSeriesPlan(this.path, this.dataType, this.encoding, this.compressor, this.props, this.tags, this.attributes, this.alias);
    }
}

