/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.handler;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.db.protocol.rest.handler.ExceptionHandler;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.rpc.TSStatusCode;

public class AuthorizationHandler {
    public Response checkAuthority(SecurityContext securityContext, PhysicalPlan physicalPlan) {
        try {
            if (!SessionManager.getInstance().checkAuthorization(physicalPlan, securityContext.getUserPrincipal().getName())) {
                return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.NO_PERMISSION_ERROR.getStatusCode())).message(TSStatusCode.NO_PERMISSION_ERROR.name())).build();
            }
        }
        catch (AuthException e) {
            return Response.ok().entity((Object)ExceptionHandler.tryCatchException((Exception)((Object)e))).build();
        }
        return null;
    }
}

