/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.mqtt;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.mqtt.PayloadFormatter;
import org.apache.iotdb.db.utils.JarLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadFormatManager {
    private static final Logger logger = LoggerFactory.getLogger(PayloadFormatManager.class);
    private static String mqttDir;
    private static Map<String, PayloadFormatter> mqttPayloadPluginMap;

    private static void init() {
        mqttDir = IoTDBDescriptor.getInstance().getConfig().getMqttDir();
        logger.info("mqttDir: {}", (Object)mqttDir);
        try {
            PayloadFormatManager.makeMqttPluginDir();
            PayloadFormatManager.buildMqttPluginMap();
        }
        catch (IOException e) {
            logger.error("MQTT PayloadFormatManager init() error.", (Throwable)e);
        }
    }

    public static PayloadFormatter getPayloadFormat(String name) {
        PayloadFormatter formatter = mqttPayloadPluginMap.get(name);
        Preconditions.checkArgument((formatter != null ? 1 : 0) != 0, (Object)("Unknown payload format named: " + name));
        return formatter;
    }

    private static void makeMqttPluginDir() throws IOException {
        File file = SystemFileFactory.INSTANCE.getFile(mqttDir);
        if (file.exists() && file.isDirectory()) {
            return;
        }
        FileUtils.forceMkdir((File)file);
    }

    private static void buildMqttPluginMap() throws IOException {
        ServiceLoader<PayloadFormatter> payloadFormatters = ServiceLoader.load(PayloadFormatter.class);
        for (PayloadFormatter formatter : payloadFormatters) {
            if (formatter == null) {
                logger.error("PayloadFormatManager(), formatter is null.");
                continue;
            }
            String pluginName = formatter.getName();
            mqttPayloadPluginMap.put(pluginName, formatter);
            logger.info("PayloadFormatManager(), find MQTT Payload Plugin {}.", (Object)pluginName);
        }
        Object[] jarURLs = JarLoaderUtil.getExternalJarURLs(mqttDir);
        logger.debug("MQTT Plugin jarURLs: {}", jarURLs);
        for (Object jarUrl : jarURLs) {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{jarUrl});
            ServiceLoader<PayloadFormatter> payloadFormatters2 = ServiceLoader.load(PayloadFormatter.class, classLoader);
            for (PayloadFormatter formatter : payloadFormatters2) {
                if (formatter == null) {
                    logger.error("PayloadFormatManager(), formatter is null.");
                    continue;
                }
                String pluginName = formatter.getName();
                if (mqttPayloadPluginMap.containsKey(pluginName)) continue;
                mqttPayloadPluginMap.put(pluginName, formatter);
                logger.info("PayloadFormatManager(), find MQTT Payload Plugin {}.", (Object)pluginName);
            }
        }
    }

    static {
        mqttPayloadPluginMap = new HashMap<String, PayloadFormatter>();
        PayloadFormatManager.init();
    }
}

