/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.sql;

import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.mpp.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.DivisionExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.ModuloExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.MultiplicationExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.SubtractionExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.NegationExpression;
import org.apache.iotdb.db.protocol.influxdb.operator.InfluxQueryOperator;
import org.apache.iotdb.db.protocol.influxdb.operator.InfluxSelectComponent;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromComponent;
import org.apache.iotdb.db.qp.logical.crud.WhereComponent;
import org.apache.iotdb.db.qp.sql.InfluxDBSqlParser;
import org.apache.iotdb.db.qp.sql.InfluxDBSqlParserBaseVisitor;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;

public class InfluxDBSqlVisitor
extends InfluxDBSqlParserBaseVisitor<Operator> {
    private InfluxQueryOperator queryOp;

    public Operator visitSingleStatement(InfluxDBSqlParser.SingleStatementContext ctx) {
        return (Operator)this.visit((ParseTree)ctx.statement());
    }

    public Operator visitSelectStatement(InfluxDBSqlParser.SelectStatementContext ctx) {
        this.queryOp = new InfluxQueryOperator();
        this.parseSelectClause(ctx.selectClause());
        this.parseFromClause(ctx.fromClause());
        if (ctx.whereClause() != null) {
            WhereComponent whereComponent = this.parseWhereClause(ctx.whereClause());
            this.queryOp.setWhereComponent(whereComponent);
        }
        return this.queryOp;
    }

    public void parseSelectClause(InfluxDBSqlParser.SelectClauseContext ctx) {
        InfluxSelectComponent influxSelectComponent = new InfluxSelectComponent();
        for (InfluxDBSqlParser.ResultColumnContext resultColumnContext : ctx.resultColumn()) {
            influxSelectComponent.addResultColumn(this.parseResultColumn(resultColumnContext));
        }
        this.queryOp.setSelectComponent(influxSelectComponent);
    }

    private void parseFromClause(InfluxDBSqlParser.FromClauseContext fromClause) {
        FromComponent fromComponent = new FromComponent();
        for (InfluxDBSqlParser.NodeNameContext nodeName : fromClause.nodeName()) {
            fromComponent.addPrefixTablePath(new PartialPath(nodeName.getText(), false));
        }
        this.queryOp.setFromComponent(fromComponent);
    }

    private WhereComponent parseWhereClause(InfluxDBSqlParser.WhereClauseContext ctx) {
        FilterOperator whereOp = new FilterOperator();
        whereOp.addChildOperator(this.parseOrExpression(ctx.orExpression()));
        return new WhereComponent(whereOp.getChildren().get(0));
    }

    private FilterOperator parseOrExpression(InfluxDBSqlParser.OrExpressionContext ctx) {
        if (ctx.andExpression().size() == 1) {
            return this.parseAndExpression(ctx.andExpression(0));
        }
        FilterOperator binaryOp = new FilterOperator(FilterConstant.FilterType.KW_OR);
        if (ctx.andExpression().size() > 2) {
            binaryOp.addChildOperator(this.parseAndExpression(ctx.andExpression(0)));
            binaryOp.addChildOperator(this.parseAndExpression(ctx.andExpression(1)));
            for (int i = 2; i < ctx.andExpression().size(); ++i) {
                FilterOperator operator = new FilterOperator(FilterConstant.FilterType.KW_OR);
                operator.addChildOperator(binaryOp);
                operator.addChildOperator(this.parseAndExpression(ctx.andExpression(i)));
                binaryOp = operator;
            }
        } else {
            for (InfluxDBSqlParser.AndExpressionContext andExpressionContext : ctx.andExpression()) {
                binaryOp.addChildOperator(this.parseAndExpression(andExpressionContext));
            }
        }
        return binaryOp;
    }

    private FilterOperator parseAndExpression(InfluxDBSqlParser.AndExpressionContext ctx) {
        if (ctx.predicate().size() == 1) {
            return this.parsePredicate(ctx.predicate(0));
        }
        FilterOperator binaryOp = new FilterOperator(FilterConstant.FilterType.KW_AND);
        int size = ctx.predicate().size();
        if (size > 2) {
            binaryOp.addChildOperator(this.parsePredicate(ctx.predicate(0)));
            binaryOp.addChildOperator(this.parsePredicate(ctx.predicate(1)));
            for (int i = 2; i < size; ++i) {
                FilterOperator op = new FilterOperator(FilterConstant.FilterType.KW_AND);
                op.addChildOperator(binaryOp);
                op.addChildOperator(this.parsePredicate(ctx.predicate(i)));
                binaryOp = op;
            }
        } else {
            for (InfluxDBSqlParser.PredicateContext predicateContext : ctx.predicate()) {
                binaryOp.addChildOperator(this.parsePredicate(predicateContext));
            }
        }
        return binaryOp;
    }

    private FilterOperator parsePredicate(InfluxDBSqlParser.PredicateContext ctx) {
        if (ctx.OPERATOR_NOT() != null) {
            FilterOperator notOp = new FilterOperator(FilterConstant.FilterType.KW_NOT);
            notOp.addChildOperator(this.parseOrExpression(ctx.orExpression()));
            return notOp;
        }
        if (ctx.LR_BRACKET() != null && ctx.OPERATOR_NOT() == null) {
            return this.parseOrExpression(ctx.orExpression());
        }
        String keyName = null;
        if (ctx.TIME() != null || ctx.TIMESTAMP() != null) {
            keyName = "time";
        }
        if (ctx.nodeName() != null) {
            keyName = ctx.nodeName().getText();
        }
        if (keyName == null) {
            throw new IllegalArgumentException("keyName is null, please check the sql");
        }
        return InfluxDBSqlVisitor.parseBasicFunctionOperator(ctx, keyName);
    }

    private ResultColumn parseResultColumn(InfluxDBSqlParser.ResultColumnContext resultColumnContext) {
        return new ResultColumn(this.parseExpression(resultColumnContext.expression()), resultColumnContext.AS() == null ? null : resultColumnContext.identifier().getText());
    }

    private Expression parseExpression(InfluxDBSqlParser.ExpressionContext context) {
        if (context.unaryInBracket != null) {
            return this.parseExpression(context.unaryInBracket);
        }
        if (context.unaryAfterSign != null) {
            return context.MINUS() != null ? new NegationExpression(this.parseExpression(context.expression(0))) : this.parseExpression(context.expression(0));
        }
        if (context.leftExpression != null && context.rightExpression != null) {
            Expression leftExpression = this.parseExpression(context.leftExpression);
            Expression rightExpression = this.parseExpression(context.rightExpression);
            if (context.STAR() != null) {
                return new MultiplicationExpression(leftExpression, rightExpression);
            }
            if (context.DIV() != null) {
                return new DivisionExpression(leftExpression, rightExpression);
            }
            if (context.MOD() != null) {
                return new ModuloExpression(leftExpression, rightExpression);
            }
            if (context.PLUS() != null) {
                return new AdditionExpression(leftExpression, rightExpression);
            }
            if (context.MINUS() != null) {
                return new SubtractionExpression(leftExpression, rightExpression);
            }
        }
        if (context.functionName != null) {
            return this.parseFunctionExpression(context);
        }
        if (context.nodeName() != null || context.constant() != null) {
            return new TimeSeriesOperand(new PartialPath(context.nodeName().getText(), false));
        }
        throw new UnsupportedOperationException();
    }

    private Expression parseFunctionExpression(InfluxDBSqlParser.ExpressionContext functionClause) {
        FunctionExpression functionExpression = new FunctionExpression(functionClause.functionName.getText());
        for (InfluxDBSqlParser.ExpressionContext expression : functionClause.expression()) {
            functionExpression.addExpression(this.parseExpression(expression));
        }
        for (InfluxDBSqlParser.FunctionAttributeContext functionAttribute : functionClause.functionAttribute()) {
            functionExpression.addAttribute(InfluxDBSqlVisitor.removeStringQuote(functionAttribute.functionAttributeKey.getText()), InfluxDBSqlVisitor.removeStringQuote(functionAttribute.functionAttributeValue.getText()));
        }
        return functionExpression;
    }

    private static String removeStringQuote(String src) {
        if (src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'') {
            return src.substring(1, src.length() - 1);
        }
        if (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"') {
            return src.substring(1, src.length() - 1);
        }
        throw new IllegalArgumentException("error format for string with quote:" + src);
    }

    private static Long parseDateExpression(InfluxDBSqlParser.DateExpressionContext ctx) {
        long time = InfluxDBSqlVisitor.parseTimeFormat(ctx.getChild(0).getText());
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if (ctx.getChild(i).getText().equals("+")) {
                time += DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
                continue;
            }
            time -= DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
        }
        return time;
    }

    public static long parseTimeFormat(String timestampStr) {
        if (timestampStr == null || timestampStr.trim().equals("")) {
            throw new IllegalArgumentException("input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now()")) {
            return DateTimeUtils.currentTime();
        }
        throw new IllegalArgumentException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
    }

    private static FilterOperator parseBasicFunctionOperator(InfluxDBSqlParser.PredicateContext ctx, String pathName) {
        BasicFunctionOperator basic;
        if (ctx.constant().dateExpression() != null) {
            if (!pathName.equals("time")) {
                throw new IllegalArgumentException("Date can only be used to time");
            }
            basic = new BasicFunctionOperator(FilterConstant.lexerToFilterType.get(ctx.comparisonOperator().type.getType()), new PartialPath(pathName, false), Long.toString(InfluxDBSqlVisitor.parseDateExpression(ctx.constant().dateExpression())));
        } else {
            basic = new BasicFunctionOperator(FilterConstant.lexerToFilterType.get(ctx.comparisonOperator().type.getType()), new PartialPath(pathName, false), ctx.constant().getText());
        }
        return basic;
    }
}

