/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.meta;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.protocol.influxdb.handler.NewQueryHandler;
import org.apache.iotdb.db.protocol.influxdb.meta.AbstractInfluxDBMetaManager;
import org.apache.iotdb.db.protocol.influxdb.meta.TagInfoRecords;
import org.apache.iotdb.db.protocol.influxdb.util.QueryResultUtils;
import org.apache.iotdb.db.service.thrift.impl.ClientRPCServiceImpl;
import org.apache.iotdb.db.service.thrift.impl.NewInfluxDBServiceImpl;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.IoTDBJDBCDataSet;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.influxdb.InfluxDBException;

public class NewInfluxDBMetaManager
extends AbstractInfluxDBMetaManager {
    private final ClientRPCServiceImpl clientRPCService = NewInfluxDBServiceImpl.getClientRPCService();

    private NewInfluxDBMetaManager() {
    }

    public static NewInfluxDBMetaManager getInstance() {
        return InfluxDBMetaManagerHolder.INSTANCE;
    }

    @Override
    public void recover() {
        long sessionID = 0L;
        try {
            TSOpenSessionResp tsOpenSessionResp = this.clientRPCService.openSession(new TSOpenSessionReq().setUsername("root").setPassword("root"));
            sessionID = tsOpenSessionResp.getSessionId();
            TSExecuteStatementResp resp = NewQueryHandler.executeStatement("select database_name,measurement_name,tag_name,tag_order from root.TAG_INFO ", sessionID);
            IoTDBJDBCDataSet dataSet = QueryResultUtils.creatIoTJDBCDataset(resp);
            try {
                while (dataSet.hasCachedResults()) {
                    Map<String, Integer> tagOrders;
                    Map measurement2TagOrders;
                    dataSet.constructOneRow();
                    String database = dataSet.getString("root.TAG_INFO.database_name");
                    String measurement = dataSet.getString("root.TAG_INFO.measurement_name");
                    String tag = dataSet.getString("root.TAG_INFO.tag_name");
                    Integer tagOrder = dataSet.getInt("root.TAG_INFO.tag_order");
                    if (database2Measurement2TagOrders.containsKey(database)) {
                        measurement2TagOrders = (Map)database2Measurement2TagOrders.get(database);
                        tagOrders = measurement2TagOrders.containsKey(measurement) ? (Map)measurement2TagOrders.get(measurement) : new HashMap();
                    } else {
                        measurement2TagOrders = new HashMap();
                        tagOrders = new HashMap<String, Integer>();
                    }
                    tagOrders.put(tag, tagOrder);
                    measurement2TagOrders.put(measurement, tagOrders);
                    database2Measurement2TagOrders.put(database, measurement2TagOrders);
                }
            }
            catch (StatementExecutionException e) {
                throw new InfluxDBException(e.getMessage());
            }
        }
        catch (Exception e) {
            throw new InfluxDBException(e.getMessage());
        }
        finally {
            this.clientRPCService.closeSession(new TSCloseSessionReq().setSessionId(sessionID));
        }
    }

    @Override
    public void setStorageGroup(String database, long sessionID) {
        TSStatus status = this.clientRPCService.setStorageGroup(sessionID, "root." + database);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.getCode() == TSStatusCode.STORAGE_GROUP_ALREADY_EXISTS.getStatusCode()) {
            return;
        }
        throw new InfluxDBException(status.getMessage());
    }

    @Override
    public void updateTagInfoRecords(TagInfoRecords tagInfoRecords, long sessionID) {
        try {
            List<TSInsertRecordReq> reqs = tagInfoRecords.convertToInsertRecordsReq(sessionID);
            for (TSInsertRecordReq tsInsertRecordReq : reqs) {
                TSStatus tsStatus = this.clientRPCService.insertRecord(tsInsertRecordReq);
                if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                throw new InfluxDBException(tsStatus.getMessage());
            }
        }
        catch (IoTDBConnectionException e) {
            throw new InfluxDBException(e.getMessage());
        }
    }

    private static class InfluxDBMetaManagerHolder {
        private static final NewInfluxDBMetaManager INSTANCE = new NewInfluxDBMetaManager();

        private InfluxDBMetaManagerHolder() {
        }
    }
}

