/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.datastructure.tv;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.mpp.transformation.datastructure.SerializableList;
import org.apache.iotdb.db.mpp.transformation.datastructure.tv.SerializableTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SerializableFloatTVList
extends SerializableTVList {
    protected static int calculateCapacity(float memoryLimitInMB) {
        float memoryLimitInB = memoryLimitInMB * 1048576.0f / 2.0f;
        return 1000 * (int)(memoryLimitInB / 12125.0f);
    }

    protected SerializableFloatTVList(SerializableList.SerializationRecorder serializationRecorder) {
        super(TSDataType.FLOAT, serializationRecorder);
    }

    @Override
    public void serialize(PublicBAOS outputStream) throws IOException {
        int size = this.length();
        this.serializationRecorder.setSerializedElementSize(size);
        int serializedByteLength = 0;
        for (int i = 0; i < size; ++i) {
            serializedByteLength += ReadWriteIOUtils.write((long)this.getTimeByIndex(i), (OutputStream)outputStream);
            serializedByteLength += ReadWriteIOUtils.write((float)this.getFloatByIndex(i), (OutputStream)outputStream);
        }
        this.serializationRecorder.setSerializedByteLength(serializedByteLength);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        int serializedElementSize = this.serializationRecorder.getSerializedElementSize();
        for (int i = 0; i < serializedElementSize; ++i) {
            this.putFloat(ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer), ReadWriteIOUtils.readFloat((ByteBuffer)byteBuffer));
        }
    }

    @Override
    public void release() {
        this.timeRet = null;
        this.floatRet = null;
    }
}

