/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.unary;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public class RegularTransformer
extends UnaryTransformer {
    private final Pattern pattern;

    public RegularTransformer(LayerPointReader layerPointReader, Pattern pattern) {
        super(layerPointReader);
        this.pattern = pattern;
        if (this.layerPointReaderDataType != TSDataType.TEXT) {
            throw new UnSupportedDataTypeException("Unsupported data type: " + layerPointReader.getDataType().toString());
        }
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.BOOLEAN;
    }

    @Override
    protected void transformAndCache() throws QueryProcessException, IOException {
        Binary binary = this.layerPointReader.currentBinary();
        this.cachedBoolean = this.pattern.matcher(binary.getStringValue()).find();
    }
}

