/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.ternary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.ternary.TernaryTransformer;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class CompareTernaryTransformer
extends TernaryTransformer {
    protected final Evaluator evaluator;

    protected CompareTernaryTransformer(LayerPointReader firstPointReader, LayerPointReader secondPointReader, LayerPointReader thirdPointReader) throws UnSupportedDataTypeException {
        super(firstPointReader, secondPointReader, thirdPointReader);
        this.evaluator = TSDataType.TEXT.equals((Object)this.firstPointReaderDataType) ? this.constructTextEvaluator() : this.constructNumberEvaluator();
    }

    protected abstract Evaluator constructNumberEvaluator();

    protected abstract Evaluator constructTextEvaluator();

    @Override
    protected final void checkType() {
        if (this.firstPointReaderDataType.equals((Object)this.secondPointReaderDataType) && this.firstPointReaderDataType.equals((Object)this.thirdPointReaderDataType)) {
            return;
        }
        if (this.firstPointReaderDataType.equals((Object)TSDataType.BOOLEAN) || this.secondPointReaderDataType.equals((Object)TSDataType.BOOLEAN) || this.thirdPointReaderDataType.equals((Object)TSDataType.BOOLEAN)) {
            throw new UnSupportedDataTypeException(TSDataType.BOOLEAN.toString());
        }
        if (this.firstPointReaderDataType.equals((Object)TSDataType.TEXT) || this.secondPointReaderDataType.equals((Object)TSDataType.TEXT) || this.thirdPointReaderDataType.equals((Object)TSDataType.TEXT)) {
            throw new UnSupportedDataTypeException(TSDataType.TEXT.toString());
        }
    }

    @Override
    protected final void transformAndCache() throws QueryProcessException, IOException {
        this.cachedBoolean = this.evaluator.evaluate();
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.BOOLEAN;
    }

    @FunctionalInterface
    public static interface Evaluator {
        public boolean evaluate() throws QueryProcessException, IOException;
    }
}

