/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.intermediate;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.LayerRowReader;
import org.apache.iotdb.db.mpp.transformation.api.LayerRowWindowReader;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SessionTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.StateWindowAccessStrategy;

public abstract class IntermediateLayer {
    protected static final int CACHE_BLOCK_SIZE = 2;
    protected final Expression expression;
    protected final long queryId;
    protected final float memoryBudgetInMB;

    protected IntermediateLayer(Expression expression, long queryId, float memoryBudgetInMB) {
        this.expression = expression;
        this.queryId = queryId;
        this.memoryBudgetInMB = memoryBudgetInMB;
    }

    public abstract LayerPointReader constructPointReader();

    public abstract LayerRowReader constructRowReader();

    public final LayerRowWindowReader constructRowWindowReader(AccessStrategy strategy, float memoryBudgetInMB) throws QueryProcessException, IOException {
        switch (strategy.getAccessStrategyType()) {
            case SLIDING_TIME_WINDOW: {
                return this.constructRowSlidingTimeWindowReader((SlidingTimeWindowAccessStrategy)strategy, memoryBudgetInMB);
            }
            case SLIDING_SIZE_WINDOW: {
                return this.constructRowSlidingSizeWindowReader((SlidingSizeWindowAccessStrategy)strategy, memoryBudgetInMB);
            }
            case SESSION_TIME_WINDOW: {
                return this.constructRowSessionTimeWindowReader((SessionTimeWindowAccessStrategy)strategy, memoryBudgetInMB);
            }
            case STATE_WINDOW: {
                return this.constructRowStateWindowReader((StateWindowAccessStrategy)strategy, memoryBudgetInMB);
            }
        }
        throw new IllegalStateException("Unexpected access strategy: " + strategy.getAccessStrategyType());
    }

    protected abstract LayerRowWindowReader constructRowSlidingSizeWindowReader(SlidingSizeWindowAccessStrategy var1, float var2) throws QueryProcessException;

    protected abstract LayerRowWindowReader constructRowSlidingTimeWindowReader(SlidingTimeWindowAccessStrategy var1, float var2) throws QueryProcessException, IOException;

    protected abstract LayerRowWindowReader constructRowSessionTimeWindowReader(SessionTimeWindowAccessStrategy var1, float var2) throws QueryProcessException, IOException;

    protected abstract LayerRowWindowReader constructRowStateWindowReader(StateWindowAccessStrategy var1, float var2) throws QueryProcessException, IOException;

    public String toString() {
        return this.expression.toString();
    }
}

