/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.input;

import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.mpp.transformation.dag.input.IUDFInputDataSet;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class TsBlockInputDataSet
implements IUDFInputDataSet {
    private final Operator operator;
    private final List<TSDataType> dataTypes;
    private TsBlock.TsBlockRowIterator tsBlockRowIterator;

    public TsBlockInputDataSet(Operator operator, List<TSDataType> dataTypes) {
        this.operator = operator;
        this.dataTypes = dataTypes;
    }

    @Override
    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    @Override
    public boolean hasNextRowInObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    public YieldableState canYieldNextRowInObjects() {
        if (this.tsBlockRowIterator == null) {
            if (this.operator.isBlocked() != Operator.NOT_BLOCKED) {
                return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
            }
            if (!this.operator.hasNext()) {
                return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
            }
            TsBlock tsBlock = this.operator.next();
            if (tsBlock == null) {
                return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
            }
            this.tsBlockRowIterator = tsBlock.getTsBlockRowIterator();
        }
        if (this.tsBlockRowIterator.hasNext()) {
            return YieldableState.YIELDABLE;
        }
        this.tsBlockRowIterator = null;
        if (this.operator.isBlocked() != Operator.NOT_BLOCKED) {
            return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
        }
        return this.operator.hasNext() ? YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA : YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
    }

    @Override
    public Object[] nextRowInObjects() {
        return this.tsBlockRowIterator.next();
    }
}

