/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.sys.sync;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.IConfigStatement;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;

public class CreatePipeStatement
extends Statement
implements IConfigStatement {
    private String pipeName;
    private String pipeSinkName;
    private long startTime;
    private Map<String, String> pipeAttributes;

    public CreatePipeStatement(StatementType createPipeStatement) {
        this.statementType = createPipeStatement;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public String getPipeSinkName() {
        return this.pipeSinkName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Map<String, String> getPipeAttributes() {
        return this.pipeAttributes;
    }

    public void setPipeName(String pipeName) {
        this.pipeName = pipeName;
    }

    public void setPipeSinkName(String pipeSinkName) {
        this.pipeSinkName = pipeSinkName;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setPipeAttributes(Map<String, String> pipeAttributes) {
        this.pipeAttributes = pipeAttributes;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCreatePipe(this, context);
    }

    public static CreatePipeStatement parseString(String parsedString) throws IOException {
        String[] split = parsedString.split(",");
        if (split.length < 4) {
            throw new IOException("Parsing CreatePipePlan error. Attributes is less than expected.");
        }
        CreatePipeStatement statement = new CreatePipeStatement(StatementType.CREATE_PIPE);
        statement.setPipeName(split[0]);
        statement.setPipeSinkName(split[1]);
        statement.setStartTime(Long.parseLong(split[2]));
        int size = Integer.parseInt(split[3]) << 1;
        if (split.length != size + 4) {
            throw new IOException("Parsing CreatePipePlan error. Attributes number is wrong.");
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < size; i += 2) {
            attributes.put(split[i + 4], split[i + 5]);
        }
        statement.setPipeAttributes(attributes);
        return statement;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.pipeName).append(",");
        builder.append(this.pipeSinkName).append(",");
        builder.append(this.startTime).append(",");
        builder.append(this.pipeAttributes.size()).append(",");
        for (Map.Entry<String, String> entry : this.pipeAttributes.entrySet()) {
            builder.append(entry.getKey()).append(",");
            builder.append(entry.getValue()).append(",");
        }
        return builder.toString();
    }
}

