/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.literal;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.statement.literal.Literal;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class StringLiteral
extends Literal {
    private final String value;

    public StringLiteral(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)Literal.LiteralType.STRING.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.value, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)Literal.LiteralType.STRING.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.value, (OutputStream)stream);
    }

    @Override
    public boolean isDataTypeConsistency(TSDataType dataType) {
        return dataType == TSDataType.TEXT;
    }

    @Override
    public String getDataTypeString() {
        return TSDataType.TEXT.toString();
    }

    @Override
    public Binary getBinary() {
        return new Binary(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringLiteral that = (StringLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

