/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesSourceNode;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AlignedSeriesScanNode
extends SeriesSourceNode {
    private final AlignedPath alignedPath;
    private Ordering scanOrder = Ordering.ASC;
    @Nullable
    private Filter timeFilter;
    @Nullable
    private Filter valueFilter;
    private int limit;
    private int offset;
    private TRegionReplicaSet regionReplicaSet;

    public AlignedSeriesScanNode(PlanNodeId id, AlignedPath alignedPath) {
        super(id);
        this.alignedPath = alignedPath;
    }

    public AlignedSeriesScanNode(PlanNodeId id, AlignedPath alignedPath, Ordering scanOrder) {
        this(id, alignedPath);
        this.scanOrder = scanOrder;
    }

    public AlignedSeriesScanNode(PlanNodeId id, AlignedPath alignedPath, Ordering scanOrder, @Nullable Filter timeFilter, @Nullable Filter valueFilter, int limit, int offset, TRegionReplicaSet dataRegionReplicaSet) {
        this(id, alignedPath, scanOrder);
        this.timeFilter = timeFilter;
        this.valueFilter = valueFilter;
        this.limit = limit;
        this.offset = offset;
        this.regionReplicaSet = dataRegionReplicaSet;
    }

    public AlignedPath getAlignedPath() {
        return this.alignedPath;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }

    @Nullable
    public Filter getTimeFilter() {
        return this.timeFilter;
    }

    public void setTimeFilter(@Nullable Filter timeFilter) {
        this.timeFilter = timeFilter;
    }

    @Nullable
    public Filter getValueFilter() {
        return this.valueFilter;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("no child is allowed for AlignedSeriesScanNode");
    }

    @Override
    public PlanNode clone() {
        return new AlignedSeriesScanNode(this.getPlanNodeId(), this.getAlignedPath(), this.getScanOrder(), this.getTimeFilter(), this.getValueFilter(), this.getLimit(), this.getOffset(), this.regionReplicaSet);
    }

    @Override
    public List<String> getOutputColumnNames() {
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        String deviceName = this.alignedPath.getDevice();
        for (String measurement : this.alignedPath.getMeasurementList()) {
            outputColumnNames.add(deviceName.concat("." + measurement));
        }
        return outputColumnNames;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAlignedSeriesScan(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.ALIGNED_SERIES_SCAN.serialize(byteBuffer);
        this.alignedPath.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
        if (this.timeFilter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.timeFilter.serialize(byteBuffer);
        }
        if (this.valueFilter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.valueFilter.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.limit, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.offset, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.ALIGNED_SERIES_SCAN.serialize(stream);
        this.alignedPath.serialize((OutputStream)stream);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
        if (this.timeFilter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.timeFilter.serialize(stream);
        }
        if (this.valueFilter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.valueFilter.serialize(stream);
        }
        ReadWriteIOUtils.write((int)this.limit, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.offset, (OutputStream)stream);
    }

    public static AlignedSeriesScanNode deserialize(ByteBuffer byteBuffer) {
        AlignedPath alignedPath = (AlignedPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        Filter timeFilter = null;
        if (isNull == 1) {
            timeFilter = FilterFactory.deserialize((ByteBuffer)byteBuffer);
        }
        isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        Filter valueFilter = null;
        if (isNull == 1) {
            valueFilter = FilterFactory.deserialize((ByteBuffer)byteBuffer);
        }
        int limit = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        int offset = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new AlignedSeriesScanNode(planNodeId, alignedPath, scanOrder, timeFilter, valueFilter, limit, offset, null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlignedSeriesScanNode that = (AlignedSeriesScanNode)o;
        return this.limit == that.limit && this.offset == that.offset && this.alignedPath.equals((Object)that.alignedPath) && this.scanOrder == that.scanOrder && Objects.equals(this.timeFilter, that.timeFilter) && Objects.equals(this.valueFilter, that.valueFilter) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.alignedPath, this.scanOrder, this.timeFilter, this.valueFilter, this.limit, this.offset, this.regionReplicaSet});
    }

    public String toString() {
        return String.format("AlignedSeriesScanNode-%s:[SeriesPath: %s, DataRegion: %s]", this.getPlanNodeId(), this.getAlignedPath().getFormattedString(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    public PartialPath getPartitionPath() {
        return this.alignedPath;
    }

    @Override
    public Filter getPartitionTimeFilter() {
        return this.timeFilter;
    }
}

