/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.FragmentSinkNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ExchangeNode
extends PlanNode {
    private PlanNode child;
    private FragmentSinkNode remoteSourceNode;
    private TEndPoint upstreamEndpoint;
    private FragmentInstanceId upstreamInstanceId;
    private PlanNodeId upstreamPlanNodeId;
    private List<String> outputColumnNames;

    public ExchangeNode(PlanNodeId id) {
        super(id);
    }

    @Override
    public List<PlanNode> getChildren() {
        if (this.child == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)this.child);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitExchange(this, context);
    }

    @Override
    public void addChild(PlanNode child) {
        this.child = child;
    }

    @Override
    public PlanNode clone() {
        ExchangeNode node = new ExchangeNode(this.getPlanNodeId());
        if (this.remoteSourceNode != null) {
            FragmentSinkNode remoteSourceNodeClone = (FragmentSinkNode)this.remoteSourceNode.clone();
            remoteSourceNodeClone.setDownStreamPlanNodeId(node.getPlanNodeId());
            node.setRemoteSourceNode(this.remoteSourceNode);
        }
        return node;
    }

    @Override
    public int allowedChildCount() {
        return -1;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setOutputColumnNames(List<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    public void setUpstream(TEndPoint endPoint, FragmentInstanceId instanceId, PlanNodeId nodeId) {
        this.upstreamEndpoint = endPoint;
        this.upstreamInstanceId = instanceId;
        this.upstreamPlanNodeId = nodeId;
    }

    public static ExchangeNode deserialize(ByteBuffer byteBuffer) {
        int outputColumnNamesSize;
        TEndPoint endPoint = new TEndPoint(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        FragmentInstanceId fragmentInstanceId = FragmentInstanceId.deserialize(byteBuffer);
        PlanNodeId upstreamPlanNodeId = PlanNodeId.deserialize(byteBuffer);
        ArrayList<String> outputColumnNames = new ArrayList<String>(outputColumnNamesSize);
        for (outputColumnNamesSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); outputColumnNamesSize > 0; --outputColumnNamesSize) {
            outputColumnNames.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        ExchangeNode exchangeNode = new ExchangeNode(planNodeId);
        exchangeNode.setUpstream(endPoint, fragmentInstanceId, upstreamPlanNodeId);
        exchangeNode.setOutputColumnNames(outputColumnNames);
        return exchangeNode;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.EXCHANGE.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.upstreamEndpoint.getIp(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.upstreamEndpoint.getPort(), (ByteBuffer)byteBuffer);
        this.upstreamInstanceId.serialize(byteBuffer);
        this.upstreamPlanNodeId.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.outputColumnNames.size(), (ByteBuffer)byteBuffer);
        for (String outputColumnName : this.outputColumnNames) {
            ReadWriteIOUtils.write((String)outputColumnName, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.EXCHANGE.serialize(stream);
        ReadWriteIOUtils.write((String)this.upstreamEndpoint.getIp(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.upstreamEndpoint.getPort(), (OutputStream)stream);
        this.upstreamInstanceId.serialize(stream);
        this.upstreamPlanNodeId.serialize(stream);
        ReadWriteIOUtils.write((int)this.outputColumnNames.size(), (OutputStream)stream);
        for (String outputColumnName : this.outputColumnNames) {
            ReadWriteIOUtils.write((String)outputColumnName, (OutputStream)stream);
        }
    }

    public PlanNode getChild() {
        return this.child;
    }

    public void setChild(PlanNode child) {
        this.child = child;
    }

    public String toString() {
        return String.format("ExchangeNode-%s: [SourceAddress:%s]", this.getPlanNodeId(), this.getSourceAddress());
    }

    public String getSourceAddress() {
        if (this.getUpstreamEndpoint() == null) {
            return "Not assigned";
        }
        return String.format("%s/%s/%s", this.getUpstreamEndpoint().getIp(), this.getUpstreamInstanceId(), this.getUpstreamPlanNodeId());
    }

    public FragmentSinkNode getRemoteSourceNode() {
        return this.remoteSourceNode;
    }

    public void setRemoteSourceNode(FragmentSinkNode remoteSourceNode) {
        this.remoteSourceNode = remoteSourceNode;
        this.setOutputColumnNames(remoteSourceNode.getOutputColumnNames());
    }

    public void cleanChildren() {
        this.child = null;
    }

    public TEndPoint getUpstreamEndpoint() {
        return this.upstreamEndpoint;
    }

    public FragmentInstanceId getUpstreamInstanceId() {
        return this.upstreamInstanceId;
    }

    public PlanNodeId getUpstreamPlanNodeId() {
        return this.upstreamPlanNodeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExchangeNode that = (ExchangeNode)o;
        return Objects.equals(this.child, that.child) && Objects.equals(this.upstreamEndpoint, that.upstreamEndpoint) && Objects.equals(this.upstreamInstanceId, that.upstreamInstanceId) && Objects.equals(this.upstreamPlanNodeId, that.upstreamPlanNodeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.child, this.upstreamEndpoint, this.upstreamInstanceId, this.upstreamPlanNodeId);
    }
}

