/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.MultiChildNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DeviceMergeNode
extends MultiChildNode {
    private final OrderByParameter mergeOrderParameter;
    private final List<String> devices;

    public DeviceMergeNode(PlanNodeId id, List<PlanNode> children, OrderByParameter mergeOrderParameter, List<String> devices) {
        super(id, children);
        this.mergeOrderParameter = mergeOrderParameter;
        this.devices = devices;
    }

    public DeviceMergeNode(PlanNodeId id, OrderByParameter mergeOrderParameter, List<String> devices) {
        super(id);
        this.mergeOrderParameter = mergeOrderParameter;
        this.devices = devices;
    }

    public OrderByParameter getMergeOrderParameter() {
        return this.mergeOrderParameter;
    }

    public List<String> getDevices() {
        return this.devices;
    }

    @Override
    public List<PlanNode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(PlanNode child) {
        this.children.add(child);
    }

    @Override
    public int allowedChildCount() {
        return -1;
    }

    @Override
    public PlanNode clone() {
        return new DeviceMergeNode(this.getPlanNodeId(), this.getMergeOrderParameter(), this.getDevices());
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.children.stream().map(PlanNode::getOutputColumnNames).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDeviceMerge(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.DEVICE_MERGE.serialize(byteBuffer);
        this.mergeOrderParameter.serializeAttributes(byteBuffer);
        ReadWriteIOUtils.write((int)this.devices.size(), (ByteBuffer)byteBuffer);
        for (String deviceName : this.devices) {
            ReadWriteIOUtils.write((String)deviceName, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.DEVICE_MERGE.serialize(stream);
        this.mergeOrderParameter.serializeAttributes(stream);
        ReadWriteIOUtils.write((int)this.devices.size(), (OutputStream)stream);
        for (String deviceName : this.devices) {
            ReadWriteIOUtils.write((String)deviceName, (OutputStream)stream);
        }
    }

    public static DeviceMergeNode deserialize(ByteBuffer byteBuffer) {
        OrderByParameter mergeOrderParameter = OrderByParameter.deserialize(byteBuffer);
        ArrayList<String> devices = new ArrayList<String>();
        for (int devicesSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); devicesSize > 0; --devicesSize) {
            devices.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new DeviceMergeNode(planNodeId, mergeOrderParameter, devices);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceMergeNode that = (DeviceMergeNode)o;
        return Objects.equals(this.mergeOrderParameter, that.mergeOrderParameter) && Objects.equals(this.devices, that.devices) && Objects.equals(this.children, that.children);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mergeOrderParameter, this.devices, this.children);
    }

    public String toString() {
        return "DeviceMerge-" + this.getPlanNodeId();
    }
}

