/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.load;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.load.ChunkData;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFilePieceNode
extends WritePlanNode {
    private static final Logger logger = LoggerFactory.getLogger(LoadTsFilePieceNode.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private File tsFile;
    private long dataSize;
    private List<ChunkData> chunkDataList;

    public LoadTsFilePieceNode(PlanNodeId id) {
        super(id);
    }

    public LoadTsFilePieceNode(PlanNodeId id, File tsFile) {
        super(id);
        this.tsFile = tsFile;
        this.dataSize = 0L;
        this.chunkDataList = new ArrayList<ChunkData>();
    }

    public boolean exceedSize() {
        return this.dataSize >= (long)(config.getThriftMaxFrameSize() / 2) || this.dataSize >= config.getAllocateMemoryForFree() / 2L;
    }

    public void addChunkData(ChunkData chunkData) {
        this.chunkDataList.add(chunkData);
        this.dataSize += chunkData.getDataSize();
    }

    public List<ChunkData> getAllChunkData() {
        return this.chunkDataList;
    }

    public File getTsFile() {
        return this.tsFile;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return null;
    }

    @Override
    public List<PlanNode> getChildren() {
        return null;
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of load piece TsFile is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        try {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(byteOutputStream);
            this.serializeAttributes(stream);
            byteBuffer.put(byteOutputStream.toByteArray());
        }
        catch (IOException e) {
            logger.error("Serialize to ByteBuffer error.", (Throwable)e);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LOAD_TSFILE.serialize(stream);
        ReadWriteIOUtils.write((String)this.tsFile.getPath(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.chunkDataList.size(), (OutputStream)stream);
        for (ChunkData chunkData : this.chunkDataList) {
            try {
                chunkData.serialize(stream, this.tsFile);
            }
            catch (IOException e) {
                logger.error(String.format("Parse page of TsFile %s error, skip chunk %s", this.tsFile.getPath(), chunkData));
            }
        }
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        throw new NotImplementedException("split load piece TsFile is not implemented");
    }

    public static PlanNode deserialize(ByteBuffer buffer) {
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer.array());
        try {
            ReadWriteIOUtils.readShort((InputStream)stream);
            File tsFile = new File(ReadWriteIOUtils.readString((InputStream)stream));
            LoadTsFilePieceNode pieceNode = new LoadTsFilePieceNode(new PlanNodeId(""), tsFile);
            int chunkDataSize = ReadWriteIOUtils.readInt((InputStream)stream);
            for (int i = 0; i < chunkDataSize; ++i) {
                ChunkData chunkData = ChunkData.deserialize(stream);
                pieceNode.addChunkData(chunkData);
            }
            pieceNode.setPlanNodeId(PlanNodeId.deserialize(stream));
            return pieceNode;
        }
        catch (IOException | PageException e) {
            logger.error(String.format("Deserialize %s error.", LoadTsFilePieceNode.class.getName()), e);
            return null;
        }
    }

    public String toString() {
        return "LoadTsFilePieceNode{tsFile=" + this.tsFile + ", dataSize=" + this.dataSize + '}';
    }
}

