/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner;

import java.util.List;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.optimization.PlanOptimizer;
import org.apache.iotdb.db.mpp.plan.planner.LogicalPlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;

public class LogicalPlanner {
    private final MPPQueryContext context;
    private final List<PlanOptimizer> optimizers;

    public LogicalPlanner(MPPQueryContext context, List<PlanOptimizer> optimizers) {
        this.context = context;
        this.optimizers = optimizers;
    }

    public LogicalQueryPlan plan(Analysis analysis) {
        PlanNode rootNode = (PlanNode)new LogicalPlanVisitor(analysis).process(analysis.getStatement(), this.context);
        if (analysis.getStatement() instanceof QueryStatement) {
            for (PlanOptimizer optimizer : this.optimizers) {
                rootNode = optimizer.optimize(rootNode, this.context);
            }
        }
        return new LogicalQueryPlan(this.context, rootNode);
    }
}

