/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.CountSchemaMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.DevicesCountNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.DevicesSchemaScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.LevelTimeSeriesCountNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodeManagementMemoryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodePathsConvertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodePathsCountNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodePathsSchemaScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.PathsUsingTemplateScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaFetchMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaFetchScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryOrderByHeatNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.TimeSeriesCountNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.TimeSeriesSchemaScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.FillNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.FilterNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByTagNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.OffsetNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SlidingWindowAggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TimeJoinNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TransformNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.last.LastQueryNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedLastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationSourceNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.CrossSeriesAggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.FillDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.plan.statement.component.SortItem;
import org.apache.iotdb.db.mpp.plan.statement.component.SortKey;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class LogicalPlanBuilder {
    private PlanNode root;
    private final MPPQueryContext context;
    private final Function<Expression, TSDataType> getPreAnalyzedType = analysis::getType;

    public LogicalPlanBuilder(Analysis analysis, MPPQueryContext context) {
        this.context = context;
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public LogicalPlanBuilder withNewRoot(PlanNode newRoot) {
        this.root = newRoot;
        return this;
    }

    private void updateTypeProvider(Collection<Expression> expressions) {
        if (expressions == null) {
            return;
        }
        expressions.forEach(expression -> {
            if (!expression.getExpressionString().equals("Device")) {
                this.context.getTypeProvider().setType(expression.toString(), (TSDataType)this.getPreAnalyzedType.apply(expression));
            }
        });
    }

    private void updateTypeProviderWithConstantType(List<String> keys, TSDataType dataType) {
        if (keys == null) {
            return;
        }
        keys.forEach(k -> this.context.getTypeProvider().setType((String)k, dataType));
    }

    public LogicalPlanBuilder planRawDataSource(Set<Expression> sourceExpressions, Ordering scanOrder, Filter timeFilter) {
        ArrayList<PlanNode> sourceNodeList = new ArrayList<PlanNode>();
        List<PartialPath> selectedPaths = sourceExpressions.stream().map(expression -> ((TimeSeriesOperand)expression).getPath()).collect(Collectors.toList());
        List<PartialPath> groupedPaths = MetaUtils.groupAlignedSeries(selectedPaths);
        for (PartialPath path : groupedPaths) {
            if (path instanceof MeasurementPath) {
                SeriesScanNode seriesScanNode = new SeriesScanNode(this.context.getQueryId().genPlanNodeId(), (MeasurementPath)path, scanOrder);
                seriesScanNode.setTimeFilter(timeFilter);
                sourceNodeList.add(seriesScanNode);
                continue;
            }
            if (path instanceof AlignedPath) {
                AlignedSeriesScanNode alignedSeriesScanNode = new AlignedSeriesScanNode(this.context.getQueryId().genPlanNodeId(), (AlignedPath)path, scanOrder);
                alignedSeriesScanNode.setTimeFilter(timeFilter);
                sourceNodeList.add(alignedSeriesScanNode);
                continue;
            }
            throw new IllegalArgumentException("unexpected path type");
        }
        this.updateTypeProvider(sourceExpressions);
        this.root = this.convergeWithTimeJoin(sourceNodeList, scanOrder);
        return this;
    }

    public LogicalPlanBuilder planLast(Set<Expression> sourceExpressions, Filter globalTimeFilter, OrderByParameter mergeOrderParameter) {
        ArrayList<PlanNode> sourceNodeList = new ArrayList<PlanNode>();
        for (Expression sourceExpression : sourceExpressions) {
            MeasurementPath selectPath = (MeasurementPath)((TimeSeriesOperand)sourceExpression).getPath();
            if (selectPath.isUnderAlignedEntity()) {
                sourceNodeList.add(new AlignedLastQueryScanNode(this.context.getQueryId().genPlanNodeId(), new AlignedPath(selectPath)));
                continue;
            }
            sourceNodeList.add(new LastQueryScanNode(this.context.getQueryId().genPlanNodeId(), selectPath));
        }
        this.updateTypeProvider(sourceExpressions);
        this.root = new LastQueryNode(this.context.getQueryId().genPlanNodeId(), sourceNodeList, globalTimeFilter, mergeOrderParameter);
        ColumnHeaderConstant.lastQueryColumnHeaders.forEach(columnHeader -> this.context.getTypeProvider().setType(columnHeader.getColumnName(), columnHeader.getColumnType()));
        return this;
    }

    public LogicalPlanBuilder planAggregationSource(AggregationStep curStep, Ordering scanOrder, Filter timeFilter, GroupByTimeParameter groupByTimeParameter, Set<Expression> aggregationExpressions, Set<Expression> sourceTransformExpressions, LinkedHashMap<Expression, Set<Expression>> crossGroupByAggregations, List<String> tagKeys, Map<List<String>, LinkedHashMap<Expression, List<Expression>>> tagValuesToGroupedTimeseriesOperands) {
        boolean needCheckAscending = groupByTimeParameter == null;
        HashMap<PartialPath, List<AggregationDescriptor>> ascendingAggregations = new HashMap<PartialPath, List<AggregationDescriptor>>();
        HashMap<PartialPath, List<AggregationDescriptor>> descendingAggregations = new HashMap<PartialPath, List<AggregationDescriptor>>();
        for (Expression aggregationExpression : aggregationExpressions) {
            this.createAggregationDescriptor((FunctionExpression)aggregationExpression, curStep, scanOrder, needCheckAscending, ascendingAggregations, descendingAggregations);
        }
        List<PlanNode> sourceNodeList = this.constructSourceNodeFromAggregationDescriptors(ascendingAggregations, descendingAggregations, scanOrder, timeFilter, groupByTimeParameter);
        this.updateTypeProvider(aggregationExpressions);
        this.updateTypeProvider(sourceTransformExpressions);
        return this.convergeAggregationSource(sourceNodeList, curStep, scanOrder, groupByTimeParameter, aggregationExpressions, crossGroupByAggregations, tagKeys, tagValuesToGroupedTimeseriesOperands);
    }

    public LogicalPlanBuilder planAggregationSourceWithIndexAdjust(AggregationStep curStep, Ordering scanOrder, Filter timeFilter, GroupByTimeParameter groupByTimeParameter, Set<Expression> aggregationExpressions, Set<Expression> sourceTransformExpressions, LinkedHashMap<Expression, Set<Expression>> crossGroupByExpressions, List<Integer> deviceViewInputIndexes) {
        Preconditions.checkArgument((aggregationExpressions.size() == deviceViewInputIndexes.size() ? 1 : 0) != 0, (Object)"Each aggregate should correspond to a column of output.");
        boolean needCheckAscending = groupByTimeParameter == null;
        HashMap<PartialPath, List<AggregationDescriptor>> ascendingAggregations = new HashMap<PartialPath, List<AggregationDescriptor>>();
        HashMap<PartialPath, List<AggregationDescriptor>> descendingAggregations = new HashMap<PartialPath, List<AggregationDescriptor>>();
        HashMap<AggregationDescriptor, Integer> aggregationToIndexMap = new HashMap<AggregationDescriptor, Integer>();
        int index = 0;
        for (Expression aggregationExpression : aggregationExpressions) {
            AggregationDescriptor aggregationDescriptor = this.createAggregationDescriptor((FunctionExpression)aggregationExpression, curStep, scanOrder, needCheckAscending, ascendingAggregations, descendingAggregations);
            aggregationToIndexMap.put(aggregationDescriptor, deviceViewInputIndexes.get(index));
            ++index;
        }
        List<PlanNode> sourceNodeList = this.constructSourceNodeFromAggregationDescriptors(ascendingAggregations, descendingAggregations, scanOrder, timeFilter, groupByTimeParameter);
        this.updateTypeProvider(aggregationExpressions);
        this.updateTypeProvider(sourceTransformExpressions);
        if (!curStep.isOutputPartial()) {
            deviceViewInputIndexes.clear();
            deviceViewInputIndexes.addAll(sourceNodeList.stream().map(planNode -> ((SeriesAggregationSourceNode)planNode).getAggregationDescriptorList()).flatMap(Collection::stream).map(aggregationToIndexMap::get).collect(Collectors.toList()));
        }
        return this.convergeAggregationSource(sourceNodeList, curStep, scanOrder, groupByTimeParameter, aggregationExpressions, crossGroupByExpressions, null, null);
    }

    private AggregationDescriptor createAggregationDescriptor(FunctionExpression sourceExpression, AggregationStep curStep, Ordering scanOrder, boolean needCheckAscending, Map<PartialPath, List<AggregationDescriptor>> ascendingAggregations, Map<PartialPath, List<AggregationDescriptor>> descendingAggregations) {
        AggregationDescriptor aggregationDescriptor = new AggregationDescriptor(sourceExpression.getFunctionName(), curStep, sourceExpression.getExpressions());
        if (curStep.isOutputPartial()) {
            LogicalPlanBuilder.updateTypeProviderByPartialAggregation(aggregationDescriptor, this.context.getTypeProvider());
        }
        PartialPath selectPath = ((TimeSeriesOperand)sourceExpression.getExpressions().get(0)).getPath();
        if (!needCheckAscending || SchemaUtils.isConsistentWithScanOrder(aggregationDescriptor.getAggregationType(), scanOrder)) {
            ascendingAggregations.computeIfAbsent(selectPath, key -> new ArrayList()).add(aggregationDescriptor);
        } else {
            descendingAggregations.computeIfAbsent(selectPath, key -> new ArrayList()).add(aggregationDescriptor);
        }
        return aggregationDescriptor;
    }

    private List<PlanNode> constructSourceNodeFromAggregationDescriptors(Map<PartialPath, List<AggregationDescriptor>> ascendingAggregations, Map<PartialPath, List<AggregationDescriptor>> descendingAggregations, Ordering scanOrder, Filter timeFilter, GroupByTimeParameter groupByTimeParameter) {
        ArrayList<PlanNode> sourceNodeList = new ArrayList<PlanNode>();
        boolean needCheckAscending = groupByTimeParameter == null;
        Map<PartialPath, List<AggregationDescriptor>> groupedAscendingAggregations = MetaUtils.groupAlignedAggregations(ascendingAggregations);
        for (Map.Entry<PartialPath, List<AggregationDescriptor>> pathAggregationsEntry : groupedAscendingAggregations.entrySet()) {
            sourceNodeList.add(this.createAggregationScanNode(pathAggregationsEntry.getKey(), pathAggregationsEntry.getValue(), scanOrder, groupByTimeParameter, timeFilter));
        }
        if (needCheckAscending) {
            Map<PartialPath, List<AggregationDescriptor>> groupedDescendingAggregations = MetaUtils.groupAlignedAggregations(descendingAggregations);
            for (Map.Entry<PartialPath, List<AggregationDescriptor>> pathAggregationsEntry : groupedDescendingAggregations.entrySet()) {
                sourceNodeList.add(this.createAggregationScanNode(pathAggregationsEntry.getKey(), pathAggregationsEntry.getValue(), scanOrder.reverse(), null, timeFilter));
            }
        }
        return sourceNodeList;
    }

    private LogicalPlanBuilder convergeAggregationSource(List<PlanNode> sourceNodeList, AggregationStep curStep, Ordering scanOrder, GroupByTimeParameter groupByTimeParameter, Set<Expression> aggregationExpressions, LinkedHashMap<Expression, Set<Expression>> crossGroupByExpressions, List<String> tagKeys, Map<List<String>, LinkedHashMap<Expression, List<Expression>>> tagValuesToGroupedTimeseriesOperands) {
        if (curStep.isOutputPartial()) {
            if (groupByTimeParameter != null && groupByTimeParameter.hasOverlap()) {
                curStep = crossGroupByExpressions != null ? AggregationStep.INTERMEDIATE : AggregationStep.FINAL;
                this.root = this.convergeWithTimeJoin(sourceNodeList, scanOrder);
                this.root = this.createSlidingWindowAggregationNode(this.getRoot(), aggregationExpressions, groupByTimeParameter, curStep, scanOrder);
                if (crossGroupByExpressions != null) {
                    curStep = AggregationStep.FINAL;
                    this.root = tagKeys != null ? this.createGroupByTagNode(tagKeys, tagValuesToGroupedTimeseriesOperands, crossGroupByExpressions.keySet(), Collections.singletonList(this.getRoot()), curStep, groupByTimeParameter, scanOrder) : this.createGroupByTLevelNode(Collections.singletonList(this.getRoot()), crossGroupByExpressions, curStep, groupByTimeParameter, scanOrder);
                }
            } else if (tagKeys != null) {
                curStep = AggregationStep.FINAL;
                this.root = this.createGroupByTagNode(tagKeys, tagValuesToGroupedTimeseriesOperands, crossGroupByExpressions.keySet(), sourceNodeList, curStep, groupByTimeParameter, scanOrder);
            } else if (crossGroupByExpressions != null) {
                curStep = AggregationStep.FINAL;
                this.root = this.createGroupByTLevelNode(sourceNodeList, crossGroupByExpressions, curStep, groupByTimeParameter, scanOrder);
            }
        } else {
            this.root = this.convergeWithTimeJoin(sourceNodeList, scanOrder);
        }
        return this;
    }

    public static void updateTypeProviderByPartialAggregation(AggregationDescriptor aggregationDescriptor, TypeProvider typeProvider) {
        List<AggregationType> splitAggregations = SchemaUtils.splitPartialAggregation(aggregationDescriptor.getAggregationType());
        String inputExpressionStr = aggregationDescriptor.getInputExpressions().get(0).toString();
        for (AggregationType aggregation : splitAggregations) {
            String functionName = aggregation.toString().toLowerCase();
            TSDataType aggregationType = SchemaUtils.getAggregationType(functionName);
            typeProvider.setType(String.format("%s(%s)", functionName, inputExpressionStr), aggregationType == null ? typeProvider.getType(inputExpressionStr) : aggregationType);
        }
    }

    public static void updateTypeProviderByPartialAggregation(CrossSeriesAggregationDescriptor aggregationDescriptor, TypeProvider typeProvider) {
        List<AggregationType> splitAggregations = SchemaUtils.splitPartialAggregation(aggregationDescriptor.getAggregationType());
        PartialPath path = ((TimeSeriesOperand)aggregationDescriptor.getOutputExpression()).getPath();
        for (AggregationType aggregationType : splitAggregations) {
            String functionName = aggregationType.toString().toLowerCase();
            typeProvider.setType(String.format("%s(%s)", functionName, path.getFullPath()), SchemaUtils.getSeriesTypeByPath(path, functionName));
        }
    }

    private PlanNode convergeWithTimeJoin(List<PlanNode> sourceNodes, Ordering mergeOrder) {
        PlanNode tmpNode = sourceNodes.size() == 1 ? sourceNodes.get(0) : new TimeJoinNode(this.context.getQueryId().genPlanNodeId(), mergeOrder, sourceNodes);
        return tmpNode;
    }

    public LogicalPlanBuilder planDeviceView(Map<String, PlanNode> deviceNameToSourceNodesMap, Set<Expression> deviceViewOutputExpressions, Map<String, List<Integer>> deviceToMeasurementIndexesMap, Ordering mergeOrder) {
        List<String> outputColumnNames = deviceViewOutputExpressions.stream().map(Expression::getExpressionString).collect(Collectors.toList());
        DeviceViewNode deviceViewNode = new DeviceViewNode(this.context.getQueryId().genPlanNodeId(), new OrderByParameter(Arrays.asList(new SortItem(SortKey.DEVICE, Ordering.ASC), new SortItem(SortKey.TIME, mergeOrder))), outputColumnNames, deviceToMeasurementIndexesMap);
        for (Map.Entry<String, PlanNode> entry : deviceNameToSourceNodesMap.entrySet()) {
            String deviceName = entry.getKey();
            PlanNode subPlan = entry.getValue();
            deviceViewNode.addChildDeviceNode(deviceName, subPlan);
        }
        this.context.getTypeProvider().setType("Device", TSDataType.TEXT);
        this.updateTypeProvider(deviceViewOutputExpressions);
        this.root = deviceViewNode;
        return this;
    }

    public LogicalPlanBuilder planGroupByLevel(Map<Expression, Set<Expression>> groupByLevelExpressions, GroupByTimeParameter groupByTimeParameter, Ordering scanOrder) {
        if (groupByLevelExpressions == null) {
            return this;
        }
        this.root = this.createGroupByTLevelNode(Collections.singletonList(this.getRoot()), groupByLevelExpressions, AggregationStep.FINAL, groupByTimeParameter, scanOrder);
        return this;
    }

    public LogicalPlanBuilder planAggregation(Set<Expression> aggregationExpressions, GroupByTimeParameter groupByTimeParameter, AggregationStep curStep, Ordering scanOrder) {
        if (aggregationExpressions == null) {
            return this;
        }
        List<AggregationDescriptor> aggregationDescriptorList = this.constructAggregationDescriptorList(aggregationExpressions, curStep);
        this.updateTypeProvider(aggregationExpressions);
        if (curStep.isOutputPartial()) {
            aggregationDescriptorList.forEach(aggregationDescriptor -> LogicalPlanBuilder.updateTypeProviderByPartialAggregation(aggregationDescriptor, this.context.getTypeProvider()));
        }
        this.root = new AggregationNode(this.context.getQueryId().genPlanNodeId(), Collections.singletonList(this.getRoot()), aggregationDescriptorList, groupByTimeParameter, scanOrder);
        return this;
    }

    public LogicalPlanBuilder planSlidingWindowAggregation(Set<Expression> aggregationExpressions, GroupByTimeParameter groupByTimeParameter, AggregationStep curStep, Ordering scanOrder) {
        if (aggregationExpressions == null) {
            return this;
        }
        this.root = this.createSlidingWindowAggregationNode(this.getRoot(), aggregationExpressions, groupByTimeParameter, curStep, scanOrder);
        return this;
    }

    private PlanNode createSlidingWindowAggregationNode(PlanNode child, Set<Expression> aggregationExpressions, GroupByTimeParameter groupByTimeParameter, AggregationStep curStep, Ordering scanOrder) {
        List<AggregationDescriptor> aggregationDescriptorList = this.constructAggregationDescriptorList(aggregationExpressions, curStep);
        return new SlidingWindowAggregationNode(this.context.getQueryId().genPlanNodeId(), child, aggregationDescriptorList, groupByTimeParameter, scanOrder);
    }

    private PlanNode createGroupByTLevelNode(List<PlanNode> children, Map<Expression, Set<Expression>> groupByLevelExpressions, AggregationStep curStep, GroupByTimeParameter groupByTimeParameter, Ordering scanOrder) {
        ArrayList<CrossSeriesAggregationDescriptor> groupByLevelDescriptors = new ArrayList<CrossSeriesAggregationDescriptor>();
        for (Expression groupedExpression : groupByLevelExpressions.keySet()) {
            groupByLevelDescriptors.add(new CrossSeriesAggregationDescriptor(((FunctionExpression)groupedExpression).getFunctionName(), curStep, groupByLevelExpressions.get(groupedExpression).stream().map(Expression::getExpressions).flatMap(Collection::stream).collect(Collectors.toList()), groupedExpression.getExpressions().get(0)));
        }
        this.updateTypeProvider(groupByLevelExpressions.keySet());
        this.updateTypeProvider(groupByLevelDescriptors.stream().map(CrossSeriesAggregationDescriptor::getOutputExpression).collect(Collectors.toList()));
        return new GroupByLevelNode(this.context.getQueryId().genPlanNodeId(), children, groupByLevelDescriptors, groupByTimeParameter, scanOrder);
    }

    private PlanNode createGroupByTagNode(List<String> tagKeys, Map<List<String>, LinkedHashMap<Expression, List<Expression>>> tagValuesToGroupedTimeseriesOperands, Collection<Expression> groupByTagOutputExpressions, List<PlanNode> children, AggregationStep curStep, GroupByTimeParameter groupByTimeParameter, Ordering scanOrder) {
        HashMap<List<String>, List<CrossSeriesAggregationDescriptor>> tagValuesToAggregationDescriptors = new HashMap<List<String>, List<CrossSeriesAggregationDescriptor>>();
        for (List<String> tagValues : tagValuesToGroupedTimeseriesOperands.keySet()) {
            LinkedHashMap<Expression, List<Expression>> groupedTimeseriesOperands = tagValuesToGroupedTimeseriesOperands.get(tagValues);
            ArrayList<CrossSeriesAggregationDescriptor> aggregationDescriptors = new ArrayList<CrossSeriesAggregationDescriptor>();
            Iterator<Expression> iter = groupedTimeseriesOperands.keySet().iterator();
            for (Expression groupByTagOutputExpression : groupByTagOutputExpressions) {
                if (!iter.hasNext()) {
                    aggregationDescriptors.add(null);
                    continue;
                }
                Expression next = iter.next();
                if (next.equals(groupByTagOutputExpression)) {
                    String functionName = ((FunctionExpression)next).getFunctionName().toUpperCase();
                    CrossSeriesAggregationDescriptor aggregationDescriptor = new CrossSeriesAggregationDescriptor(functionName, curStep, groupedTimeseriesOperands.get(next), next.getExpressions().get(0));
                    aggregationDescriptors.add(aggregationDescriptor);
                    continue;
                }
                aggregationDescriptors.add(null);
            }
            tagValuesToAggregationDescriptors.put(tagValues, aggregationDescriptors);
        }
        this.updateTypeProvider(groupByTagOutputExpressions);
        this.updateTypeProviderWithConstantType(tagKeys, TSDataType.TEXT);
        return new GroupByTagNode(this.context.getQueryId().genPlanNodeId(), children, groupByTimeParameter, scanOrder, tagKeys, tagValuesToAggregationDescriptors, groupByTagOutputExpressions.stream().map(Expression::toString).collect(Collectors.toList()));
    }

    private SeriesAggregationSourceNode createAggregationScanNode(PartialPath selectPath, List<AggregationDescriptor> aggregationDescriptorList, Ordering scanOrder, GroupByTimeParameter groupByTimeParameter, Filter timeFilter) {
        if (selectPath instanceof MeasurementPath) {
            SeriesAggregationScanNode seriesAggregationScanNode = new SeriesAggregationScanNode(this.context.getQueryId().genPlanNodeId(), (MeasurementPath)selectPath, aggregationDescriptorList, scanOrder, groupByTimeParameter);
            seriesAggregationScanNode.setTimeFilter(timeFilter);
            return seriesAggregationScanNode;
        }
        if (selectPath instanceof AlignedPath) {
            AlignedSeriesAggregationScanNode alignedSeriesAggregationScanNode = new AlignedSeriesAggregationScanNode(this.context.getQueryId().genPlanNodeId(), (AlignedPath)selectPath, aggregationDescriptorList, scanOrder, groupByTimeParameter);
            alignedSeriesAggregationScanNode.setTimeFilter(timeFilter);
            return alignedSeriesAggregationScanNode;
        }
        throw new IllegalArgumentException("unexpected path type");
    }

    private List<AggregationDescriptor> constructAggregationDescriptorList(Set<Expression> aggregationExpressions, AggregationStep curStep) {
        return aggregationExpressions.stream().map(expression -> {
            Validate.isTrue((boolean)(expression instanceof FunctionExpression));
            return new AggregationDescriptor(((FunctionExpression)expression).getFunctionName(), curStep, expression.getExpressions());
        }).collect(Collectors.toList());
    }

    public LogicalPlanBuilder planFilterAndTransform(Expression filterExpression, Set<Expression> selectExpressions, boolean isGroupByTime, ZoneId zoneId, Ordering scanOrder) {
        if (filterExpression == null || selectExpressions.isEmpty()) {
            return this;
        }
        this.root = new FilterNode(this.context.getQueryId().genPlanNodeId(), this.getRoot(), selectExpressions.toArray(new Expression[0]), filterExpression, isGroupByTime, zoneId, scanOrder);
        this.updateTypeProvider(selectExpressions);
        return this;
    }

    public LogicalPlanBuilder planTransform(Set<Expression> selectExpressions, boolean isGroupByTime, ZoneId zoneId, Ordering scanOrder) {
        boolean needTransform = false;
        for (Expression expression : selectExpressions) {
            if (!ExpressionAnalyzer.checkIsNeedTransform(expression)) continue;
            needTransform = true;
            break;
        }
        if (!needTransform) {
            return this;
        }
        this.root = new TransformNode(this.context.getQueryId().genPlanNodeId(), this.getRoot(), selectExpressions.toArray(new Expression[0]), isGroupByTime, zoneId, scanOrder);
        this.updateTypeProvider(selectExpressions);
        return this;
    }

    public LogicalPlanBuilder planFill(FillDescriptor fillDescriptor, Ordering scanOrder) {
        if (fillDescriptor == null) {
            return this;
        }
        this.root = new FillNode(this.context.getQueryId().genPlanNodeId(), this.getRoot(), fillDescriptor, scanOrder);
        return this;
    }

    public LogicalPlanBuilder planLimit(int rowLimit) {
        if (rowLimit == 0) {
            return this;
        }
        this.root = new LimitNode(this.context.getQueryId().genPlanNodeId(), this.getRoot(), rowLimit);
        return this;
    }

    public LogicalPlanBuilder planOffset(int rowOffset) {
        if (rowOffset == 0) {
            return this;
        }
        this.root = new OffsetNode(this.context.getQueryId().genPlanNodeId(), this.getRoot(), rowOffset);
        return this;
    }

    public LogicalPlanBuilder planHaving(Expression havingExpression, Set<Expression> selectExpressions, boolean isGroupByTime, ZoneId zoneId, Ordering scanOrder) {
        if (havingExpression != null) {
            return this.planFilterAndTransform(havingExpression, selectExpressions, isGroupByTime, zoneId, scanOrder);
        }
        return this.planTransform(selectExpressions, isGroupByTime, zoneId, scanOrder);
    }

    public LogicalPlanBuilder planWhereAndSourceTransform(Expression whereExpression, Set<Expression> sourceTransformExpressions, boolean isGroupByTime, ZoneId zoneId, Ordering scanOrder) {
        if (whereExpression != null) {
            return this.planFilterAndTransform(whereExpression, sourceTransformExpressions, isGroupByTime, zoneId, scanOrder);
        }
        return this.planTransform(sourceTransformExpressions, isGroupByTime, zoneId, scanOrder);
    }

    public LogicalPlanBuilder planTimeSeriesSchemaSource(PartialPath pathPattern, String key, String value, int limit, int offset, boolean orderByHeat, boolean contains, boolean prefixPath, Map<Integer, Template> templateMap) {
        this.root = new TimeSeriesSchemaScanNode(this.context.getQueryId().genPlanNodeId(), pathPattern, key, value, limit, offset, orderByHeat, contains, prefixPath, templateMap);
        return this;
    }

    public LogicalPlanBuilder planDeviceSchemaSource(PartialPath pathPattern, int limit, int offset, boolean prefixPath, boolean hasSgCol) {
        this.root = new DevicesSchemaScanNode(this.context.getQueryId().genPlanNodeId(), pathPattern, limit, offset, prefixPath, hasSgCol);
        return this;
    }

    public LogicalPlanBuilder planSchemaQueryMerge(boolean orderByHeat) {
        SchemaQueryMergeNode schemaMergeNode = new SchemaQueryMergeNode(this.context.getQueryId().genPlanNodeId(), orderByHeat);
        schemaMergeNode.addChild(this.getRoot());
        this.root = schemaMergeNode;
        return this;
    }

    public LogicalPlanBuilder planSchemaQueryOrderByHeat(PlanNode lastPlanNode) {
        SchemaQueryOrderByHeatNode node = new SchemaQueryOrderByHeatNode(this.context.getQueryId().genPlanNodeId());
        node.addChild(this.getRoot());
        node.addChild(lastPlanNode);
        this.root = node;
        return this;
    }

    public LogicalPlanBuilder planSchemaFetchMerge(List<String> storageGroupList) {
        this.root = new SchemaFetchMergeNode(this.context.getQueryId().genPlanNodeId(), storageGroupList);
        return this;
    }

    public LogicalPlanBuilder planSchemaFetchSource(List<String> storageGroupList, PathPatternTree patternTree, Map<Integer, Template> templateMap, boolean withTags) {
        for (String storageGroup : storageGroupList) {
            try {
                PartialPath storageGroupPath = new PartialPath(storageGroup);
                PathPatternTree overlappedPatternTree = new PathPatternTree();
                for (PartialPath pathPattern : patternTree.getOverlappedPathPatterns(storageGroupPath.concatNode("**"))) {
                    overlappedPatternTree.appendFullPath(pathPattern);
                }
                this.root.addChild(new SchemaFetchScanNode(this.context.getQueryId().genPlanNodeId(), storageGroupPath, overlappedPatternTree, templateMap, withTags));
            }
            catch (IllegalPathException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public LogicalPlanBuilder planCountMerge() {
        CountSchemaMergeNode countMergeNode = new CountSchemaMergeNode(this.context.getQueryId().genPlanNodeId());
        countMergeNode.addChild(this.getRoot());
        this.root = countMergeNode;
        return this;
    }

    public LogicalPlanBuilder planDevicesCountSource(PartialPath partialPath, boolean prefixPath) {
        this.root = new DevicesCountNode(this.context.getQueryId().genPlanNodeId(), partialPath, prefixPath);
        return this;
    }

    public LogicalPlanBuilder planTimeSeriesCountSource(PartialPath partialPath, boolean prefixPath, String key, String value, boolean isContains, Map<Integer, Template> templateMap) {
        this.root = new TimeSeriesCountNode(this.context.getQueryId().genPlanNodeId(), partialPath, prefixPath, key, value, isContains, templateMap);
        return this;
    }

    public LogicalPlanBuilder planLevelTimeSeriesCountSource(PartialPath partialPath, boolean prefixPath, int level, String key, String value, boolean isContains) {
        this.root = new LevelTimeSeriesCountNode(this.context.getQueryId().genPlanNodeId(), partialPath, prefixPath, level, key, value, isContains);
        return this;
    }

    public LogicalPlanBuilder planNodePathsSchemaSource(PartialPath partialPath, Integer level) {
        this.root = new NodePathsSchemaScanNode(this.context.getQueryId().genPlanNodeId(), partialPath, level);
        return this;
    }

    public LogicalPlanBuilder planNodePathsConvert() {
        NodePathsConvertNode nodePathsConvertNode = new NodePathsConvertNode(this.context.getQueryId().genPlanNodeId());
        nodePathsConvertNode.addChild(this.getRoot());
        this.root = nodePathsConvertNode;
        return this;
    }

    public LogicalPlanBuilder planNodePathsCount() {
        NodePathsCountNode nodePathsCountNode = new NodePathsCountNode(this.context.getQueryId().genPlanNodeId());
        nodePathsCountNode.addChild(this.getRoot());
        this.root = nodePathsCountNode;
        return this;
    }

    public LogicalPlanBuilder planNodeManagementMemoryMerge(Set<TSchemaNode> data) {
        NodeManagementMemoryMergeNode memorySourceNode = new NodeManagementMemoryMergeNode(this.context.getQueryId().genPlanNodeId(), data);
        memorySourceNode.addChild(this.getRoot());
        this.root = memorySourceNode;
        return this;
    }

    public LogicalPlanBuilder planPathsUsingTemplateSource(int templateId) {
        this.root = new PathsUsingTemplateScanNode(this.context.getQueryId().genPlanNodeId(), templateId);
        return this;
    }
}

