/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule.queue;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.iotdb.db.mpp.execution.schedule.queue.ID;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IDIndexedAccessible;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IndexedBlockingQueue;

public class L2PriorityQueue<E extends IDIndexedAccessible>
extends IndexedBlockingQueue<E> {
    private SortedSet<E> workingSortedElements;
    private SortedSet<E> idleSortedElements;
    private Map<ID, E> workingKeyedElements;
    private Map<ID, E> idleKeyedElements;

    public L2PriorityQueue(int maxCapacity, Comparator<E> comparator, E queryHolder) {
        super(maxCapacity, queryHolder);
        this.workingSortedElements = new TreeSet<E>(comparator);
        this.idleSortedElements = new TreeSet<E>(comparator);
        this.workingKeyedElements = new HashMap<ID, E>();
        this.idleKeyedElements = new HashMap<ID, E>();
    }

    @Override
    protected boolean isEmpty() {
        return this.workingKeyedElements.isEmpty() && this.idleKeyedElements.isEmpty();
    }

    @Override
    protected E pollFirst() {
        if (this.workingKeyedElements.isEmpty()) {
            Map<ID, E> tmp = this.workingKeyedElements;
            this.workingKeyedElements = this.idleKeyedElements;
            this.idleKeyedElements = tmp;
            SortedSet<E> tmpSet = this.workingSortedElements;
            this.workingSortedElements = this.idleSortedElements;
            this.idleSortedElements = tmpSet;
        }
        IDIndexedAccessible element = (IDIndexedAccessible)this.workingSortedElements.first();
        this.workingSortedElements.remove(element);
        this.workingKeyedElements.remove(element.getId());
        return (E)element;
    }

    @Override
    protected void pushToQueue(E element) {
        this.idleKeyedElements.put(element.getId(), element);
        this.idleSortedElements.add(element);
    }

    @Override
    protected E remove(E element) {
        IDIndexedAccessible e = (IDIndexedAccessible)this.workingKeyedElements.remove(element.getId());
        if (e != null) {
            this.workingSortedElements.remove(e);
            return (E)e;
        }
        e = (IDIndexedAccessible)this.idleKeyedElements.remove(element.getId());
        if (e != null) {
            this.idleSortedElements.remove(e);
        }
        return (E)e;
    }

    @Override
    protected boolean contains(E element) {
        return this.workingKeyedElements.containsKey(element.getId()) || this.idleKeyedElements.containsKey(element.getId());
    }

    @Override
    protected E get(E element) {
        IDIndexedAccessible e = (IDIndexedAccessible)this.workingKeyedElements.get(element.getId());
        if (e != null) {
            return (E)e;
        }
        return (E)((IDIndexedAccessible)this.idleKeyedElements.get(element.getId()));
    }

    @Override
    protected void clearAllElements() {
        this.workingKeyedElements.clear();
        this.workingSortedElements.clear();
        this.idleKeyedElements.clear();
        this.idleSortedElements.clear();
    }
}

